/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.common;

import org.graylog.shaded.kafka09.common.InvalidTopicException;
import org.graylog.shaded.kafka09.coordinator.GroupCoordinator$;
import org.graylog.shaded.kafka09.scala.MatchError;
import org.graylog.shaded.kafka09.scala.None$;
import org.graylog.shaded.kafka09.scala.Option;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.Some;
import org.graylog.shaded.kafka09.scala.collection.immutable.Set;
import org.graylog.shaded.kafka09.scala.collection.mutable.StringBuilder;
import org.graylog.shaded.kafka09.scala.runtime.BoxedUnit;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;
import org.graylog.shaded.kafka09.scala.util.matching.Regex;

public final class Topic$ {
    public static final Topic$ MODULE$;
    private final String legalChars;
    private final int maxNameLength;
    private final Regex rgx;
    private final Set<String> InternalTopics;

    static {
        new Topic$();
    }

    public String legalChars() {
        return this.legalChars;
    }

    private int maxNameLength() {
        return this.maxNameLength;
    }

    private Regex rgx() {
        return this.rgx;
    }

    public Set<String> InternalTopics() {
        return this.InternalTopics;
    }

    public void validate(String topic) {
        if (topic.length() <= 0) {
            throw new InvalidTopicException("topic name is illegal, can't be empty");
        }
        if (topic.equals(".") || topic.equals("..")) {
            throw new InvalidTopicException("topic name cannot be \".\" or \"..\"");
        }
        if (topic.length() > this.maxNameLength()) {
            throw new InvalidTopicException(new StringBuilder().append((Object)"topic name is illegal, can't be longer than ").append(BoxesRunTime.boxToInteger(this.maxNameLength())).append((Object)" characters").toString());
        }
        Option<String> option = this.rgx().findFirstIn(topic);
        if (option instanceof Some) {
            Some some = (Some)option;
            String t = (String)some.x();
            if (t.equals(topic)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new InvalidTopicException(new StringBuilder().append((Object)"topic name ").append((Object)topic).append((Object)" is illegal, contains a character other than ASCII alphanumerics, '.', '_' and '-'").toString());
        }
        if (None$.MODULE$.equals(option)) {
            throw new InvalidTopicException(new StringBuilder().append((Object)"topic name ").append((Object)topic).append((Object)" is illegal,  contains a character other than ASCII alphanumerics, '.', '_' and '-'").toString());
        }
        throw new MatchError(option);
    }

    public boolean hasCollisionChars(String topic) {
        return topic.contains("_") || topic.contains(".");
    }

    public boolean hasCollision(String topicA, String topicB) {
        String string2 = topicA.replace('.', '_');
        String string3 = topicB.replace('.', '_');
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    private Topic$() {
        MODULE$ = this;
        this.legalChars = "[a-zA-Z0-9\\._\\-]";
        this.maxNameLength = 255;
        this.rgx = new Regex(new StringBuilder().append((Object)this.legalChars()).append((Object)"+").toString(), Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.InternalTopics = (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{GroupCoordinator$.MODULE$.GroupMetadataTopicName()}));
    }
}

