/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.log;

import java.io.File;
import java.text.NumberFormat;
import org.graylog.shaded.kafka09.common.KafkaException;
import org.graylog.shaded.kafka09.common.TopicAndPartition;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.collection.immutable.StringOps;
import org.graylog.shaded.kafka09.scala.collection.mutable.StringBuilder;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;
import org.graylog.shaded.kafka09.utils.SystemTime$;
import org.graylog.shaded.kafka09.utils.Time;

public final class Log$ {
    public static final Log$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;
    private final String DeletedFileSuffix;
    private final String CleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String CleanShutdownFile;

    static {
        new Log$();
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return this.DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String CleanShutdownFile() {
        return this.CleanShutdownFile;
    }

    public String filenamePrefixFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public File logFilename(File dir, long offset) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset)).append((Object)this.LogFileSuffix()).toString());
    }

    public File indexFilename(File dir, long offset) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset)).append((Object)this.IndexFileSuffix()).toString());
    }

    public TopicAndPartition parseTopicPartitionName(File dir) {
        String name = dir.getName();
        if (name == null || name.isEmpty() || !new StringOps(Predef$.MODULE$.augmentString(name)).contains(BoxesRunTime.boxToCharacter('-'))) {
            this.throwException(dir);
        }
        int index2 = name.lastIndexOf(45);
        String topic = name.substring(0, index2);
        String partition2 = name.substring(index2 + 1);
        if (topic.length() < 1 || partition2.length() < 1) {
            this.throwException(dir);
        }
        return new TopicAndPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition2)).toInt());
    }

    public void throwException(File dir) {
        throw new KafkaException(new StringBuilder().append((Object)"Found directory ").append((Object)dir.getCanonicalPath()).append((Object)", ").append((Object)"'").append((Object)dir.getName()).append((Object)"' is not in the form of topic-partition\n").append((Object)"If a directory does not contain Kafka topic data it should not exist in Kafka's log ").append((Object)"directory").toString());
    }

    public long $lessinit$greater$default$3() {
        return 0L;
    }

    public Time $lessinit$greater$default$5() {
        return SystemTime$.MODULE$;
    }

    private Log$() {
        MODULE$ = this;
        this.LogFileSuffix = ".log";
        this.IndexFileSuffix = ".index";
        this.DeletedFileSuffix = ".deleted";
        this.CleanedFileSuffix = ".cleaned";
        this.SwapFileSuffix = ".swap";
        this.CleanShutdownFile = ".kafka_cleanshutdown";
    }
}

