/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.clients.consumer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.graylog.shaded.org.apache.kafka09.clients.consumer.internals.AbstractPartitionAssignor;
import org.graylog.shaded.org.apache.kafka09.common.TopicPartition;
import org.graylog.shaded.org.apache.kafka09.common.utils.CircularIterator;
import org.graylog.shaded.org.apache.kafka09.common.utils.Utils;

public class RoundRobinAssignor
extends AbstractPartitionAssignor {
    @Override
    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionsPerTopic, Map<String, List<String>> subscriptions) {
        HashMap<String, List<TopicPartition>> assignment = new HashMap<String, List<TopicPartition>>();
        for (String memberId : subscriptions.keySet()) {
            assignment.put(memberId, new ArrayList());
        }
        CircularIterator<String> assigner = new CircularIterator<String>(Utils.sorted(subscriptions.keySet()));
        for (TopicPartition partition2 : this.allPartitionsSorted(partitionsPerTopic, subscriptions)) {
            String topic = partition2.topic();
            while (!subscriptions.get(assigner.peek()).contains(topic)) {
                assigner.next();
            }
            ((List)assignment.get(assigner.next())).add(partition2);
        }
        return assignment;
    }

    public List<TopicPartition> allPartitionsSorted(Map<String, Integer> partitionsPerTopic, Map<String, List<String>> subscriptions) {
        TreeSet<String> topics = new TreeSet<String>();
        for (List<String> subscription : subscriptions.values()) {
            topics.addAll(subscription);
        }
        ArrayList<TopicPartition> allPartitions = new ArrayList<TopicPartition>();
        for (String topic : topics) {
            Integer partitions = partitionsPerTopic.get(topic);
            for (int partition2 = 0; partition2 < partitions; ++partition2) {
                allPartitions.add(new TopicPartition(topic, partition2));
            }
        }
        return allPartitions;
    }

    @Override
    public String name() {
        return "roundrobin";
    }
}

