/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.network;

import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.util.Iterator;
import java.util.List;
import org.graylog.shaded.org.apache.kafka09.common.KafkaException;
import org.graylog.shaded.org.apache.kafka09.common.network.Send;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSend
implements Send {
    private static final Logger log = LoggerFactory.getLogger(MultiSend.class);
    private String dest;
    private long totalWritten = 0L;
    private List<Send> sends;
    private Iterator<Send> sendsIterator;
    private Send current;
    private boolean doneSends = false;
    private long size = 0L;

    public MultiSend(String dest, List<Send> sends) {
        this.dest = dest;
        this.sends = sends;
        this.sendsIterator = sends.iterator();
        this.nextSendOrDone();
        for (Send send2 : sends) {
            this.size += send2.size();
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public String destination() {
        return this.dest;
    }

    @Override
    public boolean completed() {
        if (this.doneSends) {
            if (this.totalWritten != this.size) {
                log.error("mismatch in sending bytes over socket; expected: " + this.size + " actual: " + this.totalWritten);
            }
            return true;
        }
        return false;
    }

    @Override
    public long writeTo(GatheringByteChannel channel) throws IOException {
        if (this.completed()) {
            throw new KafkaException("This operation cannot be completed on a complete request.");
        }
        int totalWrittenPerCall = 0;
        boolean sendComplete = false;
        do {
            long written = this.current.writeTo(channel);
            this.totalWritten += written;
            totalWrittenPerCall = (int)((long)totalWrittenPerCall + written);
            sendComplete = this.current.completed();
            if (!sendComplete) continue;
            this.nextSendOrDone();
        } while (!this.completed() && sendComplete);
        if (log.isTraceEnabled()) {
            log.trace("Bytes written as part of multisend call : " + totalWrittenPerCall + "Total bytes written so far : " + this.totalWritten + "Expected bytes to write : " + this.size);
        }
        return totalWrittenPerCall;
    }

    private void nextSendOrDone() {
        if (this.sendsIterator.hasNext()) {
            this.current = this.sendsIterator.next();
        } else {
            this.doneSends = true;
        }
    }
}

