/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ApiKeys;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ProtoUtils;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Schema;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Struct;
import org.graylog.shaded.org.apache.kafka09.common.requests.AbstractRequestResponse;

public class JoinGroupResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.JOIN_GROUP.id);
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String GENERATION_ID_KEY_NAME = "generation_id";
    private static final String GROUP_PROTOCOL_KEY_NAME = "group_protocol";
    private static final String LEADER_ID_KEY_NAME = "leader_id";
    private static final String MEMBER_ID_KEY_NAME = "member_id";
    private static final String MEMBERS_KEY_NAME = "members";
    private static final String MEMBER_METADATA_KEY_NAME = "member_metadata";
    public static final String UNKNOWN_PROTOCOL = "";
    public static final int UNKNOWN_GENERATION_ID = -1;
    public static final String UNKNOWN_MEMBER_ID = "";
    private final short errorCode;
    private final int generationId;
    private final String groupProtocol;
    private final String memberId;
    private final String leaderId;
    private final Map<String, ByteBuffer> members;

    public JoinGroupResponse(short errorCode, int generationId, String groupProtocol, String memberId, String leaderId, Map<String, ByteBuffer> groupMembers) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(ERROR_CODE_KEY_NAME, (Object)errorCode);
        this.struct.set(GENERATION_ID_KEY_NAME, (Object)generationId);
        this.struct.set(GROUP_PROTOCOL_KEY_NAME, (Object)groupProtocol);
        this.struct.set(MEMBER_ID_KEY_NAME, (Object)memberId);
        this.struct.set(LEADER_ID_KEY_NAME, (Object)leaderId);
        ArrayList<Struct> memberArray = new ArrayList<Struct>();
        for (Map.Entry<String, ByteBuffer> entries : groupMembers.entrySet()) {
            Struct memberData = this.struct.instance(MEMBERS_KEY_NAME);
            memberData.set(MEMBER_ID_KEY_NAME, (Object)entries.getKey());
            memberData.set(MEMBER_METADATA_KEY_NAME, (Object)entries.getValue());
            memberArray.add(memberData);
        }
        this.struct.set(MEMBERS_KEY_NAME, (Object)memberArray.toArray());
        this.errorCode = errorCode;
        this.generationId = generationId;
        this.groupProtocol = groupProtocol;
        this.memberId = memberId;
        this.leaderId = leaderId;
        this.members = groupMembers;
    }

    public JoinGroupResponse(Struct struct) {
        super(struct);
        this.members = new HashMap<String, ByteBuffer>();
        for (Object memberDataObj : struct.getArray(MEMBERS_KEY_NAME)) {
            Struct memberData = (Struct)memberDataObj;
            String memberId = memberData.getString(MEMBER_ID_KEY_NAME);
            ByteBuffer memberMetadata = memberData.getBytes(MEMBER_METADATA_KEY_NAME);
            this.members.put(memberId, memberMetadata);
        }
        this.errorCode = struct.getShort(ERROR_CODE_KEY_NAME);
        this.generationId = struct.getInt(GENERATION_ID_KEY_NAME);
        this.groupProtocol = struct.getString(GROUP_PROTOCOL_KEY_NAME);
        this.memberId = struct.getString(MEMBER_ID_KEY_NAME);
        this.leaderId = struct.getString(LEADER_ID_KEY_NAME);
    }

    public short errorCode() {
        return this.errorCode;
    }

    public int generationId() {
        return this.generationId;
    }

    public String groupProtocol() {
        return this.groupProtocol;
    }

    public String memberId() {
        return this.memberId;
    }

    public String leaderId() {
        return this.leaderId;
    }

    public boolean isLeader() {
        return this.memberId.equals(this.leaderId);
    }

    public Map<String, ByteBuffer> members() {
        return this.members;
    }

    public static JoinGroupResponse parse(ByteBuffer buffer) {
        return new JoinGroupResponse((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

