/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ApiKeys;
import org.graylog.shaded.org.apache.kafka09.common.protocol.Errors;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ProtoUtils;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Schema;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Struct;
import org.graylog.shaded.org.apache.kafka09.common.requests.AbstractRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.AbstractRequestResponse;
import org.graylog.shaded.org.apache.kafka09.common.requests.ListGroupsResponse;

public class ListGroupsRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.LIST_GROUPS.id);

    public ListGroupsRequest() {
        super(new Struct(CURRENT_SCHEMA));
    }

    public ListGroupsRequest(Struct struct) {
        super(struct);
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        switch (versionId) {
            case 0: {
                short errorCode = Errors.forException(e).code();
                return new ListGroupsResponse(errorCode, Collections.emptyList());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.LIST_GROUPS.id)));
    }

    public static ListGroupsRequest parse(ByteBuffer buffer, int versionId) {
        return new ListGroupsRequest(ProtoUtils.parseRequest(ApiKeys.LIST_GROUPS.id, versionId, buffer));
    }

    public static ListGroupsRequest parse(ByteBuffer buffer) {
        return new ListGroupsRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

