/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.org.apache.kafka09.common.Cluster;
import org.graylog.shaded.org.apache.kafka09.common.Node;
import org.graylog.shaded.org.apache.kafka09.common.PartitionInfo;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ApiKeys;
import org.graylog.shaded.org.apache.kafka09.common.protocol.Errors;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ProtoUtils;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Schema;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Struct;
import org.graylog.shaded.org.apache.kafka09.common.requests.AbstractRequestResponse;

public class MetadataResponse
extends AbstractRequestResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.METADATA.id);
    private static final String BROKERS_KEY_NAME = "brokers";
    private static final String TOPIC_METATDATA_KEY_NAME = "topic_metadata";
    private static final String NODE_ID_KEY_NAME = "node_id";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private static final String TOPIC_ERROR_CODE_KEY_NAME = "topic_error_code";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_METADATA_KEY_NAME = "partition_metadata";
    private static final String PARTITION_ERROR_CODE_KEY_NAME = "partition_error_code";
    private static final String PARTITION_KEY_NAME = "partition_id";
    private static final String LEADER_KEY_NAME = "leader";
    private static final String REPLICAS_KEY_NAME = "replicas";
    private static final String ISR_KEY_NAME = "isr";
    private final Cluster cluster;
    private final Map<String, Errors> errors;

    public MetadataResponse(Cluster cluster, Map<String, Errors> errors) {
        super(new Struct(CURRENT_SCHEMA));
        Struct topicData;
        ArrayList<Struct> brokerArray = new ArrayList<Struct>();
        for (Node node : cluster.nodes()) {
            Struct broker = this.struct.instance(BROKERS_KEY_NAME);
            broker.set(NODE_ID_KEY_NAME, (Object)node.id());
            broker.set(HOST_KEY_NAME, (Object)node.host());
            broker.set(PORT_KEY_NAME, (Object)node.port());
            brokerArray.add(broker);
        }
        this.struct.set(BROKERS_KEY_NAME, (Object)brokerArray.toArray());
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Errors> errorEntry : errors.entrySet()) {
            topicData = this.struct.instance(TOPIC_METATDATA_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)errorEntry.getKey());
            topicData.set(TOPIC_ERROR_CODE_KEY_NAME, (Object)errorEntry.getValue().code());
            topicData.set(PARTITION_METADATA_KEY_NAME, (Object)new Struct[0]);
            topicArray.add(topicData);
        }
        for (String topic : cluster.topics()) {
            if (errors.containsKey(topic)) continue;
            topicData = this.struct.instance(TOPIC_METATDATA_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topic);
            topicData.set(TOPIC_ERROR_CODE_KEY_NAME, (Object)Errors.NONE.code());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (PartitionInfo fetchPartitionData : cluster.partitionsForTopic(topic)) {
                Struct partitionData = topicData.instance(PARTITION_METADATA_KEY_NAME);
                partitionData.set(PARTITION_ERROR_CODE_KEY_NAME, (Object)Errors.NONE.code());
                partitionData.set(PARTITION_KEY_NAME, (Object)fetchPartitionData.partition());
                partitionData.set(LEADER_KEY_NAME, (Object)fetchPartitionData.leader().id());
                ArrayList<Integer> replicas = new ArrayList<Integer>();
                for (Node node : fetchPartitionData.replicas()) {
                    replicas.add(node.id());
                }
                partitionData.set(REPLICAS_KEY_NAME, (Object)replicas.toArray());
                ArrayList<Integer> isr = new ArrayList<Integer>();
                for (Node node : fetchPartitionData.inSyncReplicas()) {
                    isr.add(node.id());
                }
                partitionData.set(ISR_KEY_NAME, (Object)isr.toArray());
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITION_METADATA_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(TOPIC_METATDATA_KEY_NAME, (Object)topicArray.toArray());
        this.cluster = cluster;
        this.errors = errors;
    }

    public MetadataResponse(Struct struct) {
        super(struct);
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        HashMap<Integer, Node> brokers = new HashMap<Integer, Node>();
        Object[] brokerStructs = (Object[])struct.get(BROKERS_KEY_NAME);
        for (int i = 0; i < brokerStructs.length; ++i) {
            Struct broker = (Struct)brokerStructs[i];
            int nodeId = broker.getInt(NODE_ID_KEY_NAME);
            String host = broker.getString(HOST_KEY_NAME);
            int port = broker.getInt(PORT_KEY_NAME);
            brokers.put(nodeId, new Node(nodeId, host, port));
        }
        ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
        Object[] topicInfos = (Object[])struct.get(TOPIC_METATDATA_KEY_NAME);
        for (int i = 0; i < topicInfos.length; ++i) {
            Struct topicInfo = (Struct)topicInfos[i];
            short topicError = topicInfo.getShort(TOPIC_ERROR_CODE_KEY_NAME);
            String topic = topicInfo.getString(TOPIC_KEY_NAME);
            if (topicError == Errors.NONE.code()) {
                Object[] partitionInfos = (Object[])topicInfo.get(PARTITION_METADATA_KEY_NAME);
                for (int j = 0; j < partitionInfos.length; ++j) {
                    Struct partitionInfo = (Struct)partitionInfos[j];
                    int partition2 = partitionInfo.getInt(PARTITION_KEY_NAME);
                    int leader = partitionInfo.getInt(LEADER_KEY_NAME);
                    Node leaderNode = leader == -1 ? null : (Node)brokers.get(leader);
                    Object[] replicas = (Object[])partitionInfo.get(REPLICAS_KEY_NAME);
                    Node[] replicaNodes = new Node[replicas.length];
                    for (int k = 0; k < replicas.length; ++k) {
                        replicaNodes[k] = (Node)brokers.get(replicas[k]);
                    }
                    Object[] isr = (Object[])partitionInfo.get(ISR_KEY_NAME);
                    Node[] isrNodes = new Node[isr.length];
                    for (int k = 0; k < isr.length; ++k) {
                        isrNodes[k] = (Node)brokers.get(isr[k]);
                    }
                    partitions.add(new PartitionInfo(topic, partition2, leaderNode, replicaNodes, isrNodes));
                }
                continue;
            }
            errors.put(topic, Errors.forCode(topicError));
        }
        this.errors = errors;
        this.cluster = new Cluster(brokers.values(), partitions, this.unauthorizedTopics(errors));
    }

    private Set<String> unauthorizedTopics(Map<String, Errors> topicErrors) {
        if (topicErrors.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> unauthorizedTopics = new HashSet<String>();
        for (Map.Entry<String, Errors> topicErrorEntry : topicErrors.entrySet()) {
            if (topicErrorEntry.getValue() != Errors.TOPIC_AUTHORIZATION_FAILED) continue;
            unauthorizedTopics.add(topicErrorEntry.getKey());
        }
        return unauthorizedTopics;
    }

    public Map<String, Errors> errors() {
        return this.errors;
    }

    public boolean hasError(String topic) {
        return this.errors.containsKey(topic);
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public static MetadataResponse parse(ByteBuffer buffer) {
        return new MetadataResponse((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

