/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.org.apache.kafka09.common.TopicPartition;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ApiKeys;
import org.graylog.shaded.org.apache.kafka09.common.protocol.Errors;
import org.graylog.shaded.org.apache.kafka09.common.protocol.ProtoUtils;
import org.graylog.shaded.org.apache.kafka09.common.protocol.SecurityProtocol;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Schema;
import org.graylog.shaded.org.apache.kafka09.common.protocol.types.Struct;
import org.graylog.shaded.org.apache.kafka09.common.requests.AbstractRequest;
import org.graylog.shaded.org.apache.kafka09.common.requests.AbstractRequestResponse;
import org.graylog.shaded.org.apache.kafka09.common.requests.UpdateMetadataResponse;

public class UpdateMetadataRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.UPDATE_METADATA_KEY.id);
    private static final String CONTROLLER_ID_KEY_NAME = "controller_id";
    private static final String CONTROLLER_EPOCH_KEY_NAME = "controller_epoch";
    private static final String PARTITION_STATES_KEY_NAME = "partition_states";
    private static final String LIVE_BROKERS_KEY_NAME = "live_brokers";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String LEADER_KEY_NAME = "leader";
    private static final String LEADER_EPOCH_KEY_NAME = "leader_epoch";
    private static final String ISR_KEY_NAME = "isr";
    private static final String ZK_VERSION_KEY_NAME = "zk_version";
    private static final String REPLICAS_KEY_NAME = "replicas";
    private static final String BROKER_ID_KEY_NAME = "id";
    private static final String ENDPOINTS_KEY_NAME = "end_points";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private static final String SECURITY_PROTOCOL_TYPE_KEY_NAME = "security_protocol_type";
    private final int controllerId;
    private final int controllerEpoch;
    private final Map<TopicPartition, PartitionState> partitionStates;
    private final Set<Broker> liveBrokers;

    @Deprecated
    public UpdateMetadataRequest(int controllerId, int controllerEpoch, Set<BrokerEndPoint> liveBrokers2, Map<TopicPartition, PartitionState> partitionStates) {
        this(0, controllerId, controllerEpoch, partitionStates, UpdateMetadataRequest.brokerEndPointsToBrokers(liveBrokers2));
    }

    private static Set<Broker> brokerEndPointsToBrokers(Set<BrokerEndPoint> brokerEndPoints) {
        HashSet<Broker> brokers = new HashSet<Broker>(brokerEndPoints.size());
        for (BrokerEndPoint brokerEndPoint : brokerEndPoints) {
            Map<SecurityProtocol, EndPoint> endPoints = Collections.singletonMap(SecurityProtocol.PLAINTEXT, new EndPoint(brokerEndPoint.host, brokerEndPoint.port));
            brokers.add(new Broker(brokerEndPoint.id, endPoints));
        }
        return brokers;
    }

    public UpdateMetadataRequest(int controllerId, int controllerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Broker> liveBrokers2) {
        this(1, controllerId, controllerEpoch, partitionStates, liveBrokers2);
    }

    private UpdateMetadataRequest(int version, int controllerId, int controllerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Broker> liveBrokers2) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.UPDATE_METADATA_KEY.id, version)));
        this.struct.set(CONTROLLER_ID_KEY_NAME, (Object)controllerId);
        this.struct.set(CONTROLLER_EPOCH_KEY_NAME, (Object)controllerEpoch);
        ArrayList<Struct> partitionStatesData = new ArrayList<Struct>(partitionStates.size());
        for (Map.Entry<TopicPartition, PartitionState> entry2 : partitionStates.entrySet()) {
            Struct partitionStateData = this.struct.instance(PARTITION_STATES_KEY_NAME);
            TopicPartition topicPartition = entry2.getKey();
            partitionStateData.set(TOPIC_KEY_NAME, (Object)topicPartition.topic());
            partitionStateData.set(PARTITION_KEY_NAME, (Object)topicPartition.partition());
            PartitionState partitionState = entry2.getValue();
            partitionStateData.set(CONTROLLER_EPOCH_KEY_NAME, (Object)partitionState.controllerEpoch);
            partitionStateData.set(LEADER_KEY_NAME, (Object)partitionState.leader);
            partitionStateData.set(LEADER_EPOCH_KEY_NAME, (Object)partitionState.leaderEpoch);
            partitionStateData.set(ISR_KEY_NAME, (Object)partitionState.isr.toArray());
            partitionStateData.set(ZK_VERSION_KEY_NAME, (Object)partitionState.zkVersion);
            partitionStateData.set(REPLICAS_KEY_NAME, (Object)partitionState.replicas.toArray());
            partitionStatesData.add(partitionStateData);
        }
        this.struct.set(PARTITION_STATES_KEY_NAME, (Object)partitionStatesData.toArray());
        ArrayList<Struct> brokersData = new ArrayList<Struct>(liveBrokers2.size());
        for (Broker broker : liveBrokers2) {
            Struct brokerData = this.struct.instance(LIVE_BROKERS_KEY_NAME);
            brokerData.set(BROKER_ID_KEY_NAME, (Object)broker.id);
            if (version == 0) {
                EndPoint endPoint = broker.endPoints.get((Object)SecurityProtocol.PLAINTEXT);
                brokerData.set(HOST_KEY_NAME, (Object)endPoint.host);
                brokerData.set(PORT_KEY_NAME, (Object)endPoint.port);
            } else {
                ArrayList<Struct> endPointsData = new ArrayList<Struct>(broker.endPoints.size());
                for (Map.Entry<SecurityProtocol, EndPoint> entry3 : broker.endPoints.entrySet()) {
                    Struct endPointData = brokerData.instance(ENDPOINTS_KEY_NAME);
                    endPointData.set(PORT_KEY_NAME, (Object)entry3.getValue().port);
                    endPointData.set(HOST_KEY_NAME, (Object)entry3.getValue().host);
                    endPointData.set(SECURITY_PROTOCOL_TYPE_KEY_NAME, (Object)entry3.getKey().id);
                    endPointsData.add(endPointData);
                }
                brokerData.set(ENDPOINTS_KEY_NAME, (Object)endPointsData.toArray());
            }
            brokersData.add(brokerData);
        }
        this.struct.set(LIVE_BROKERS_KEY_NAME, (Object)brokersData.toArray());
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.partitionStates = partitionStates;
        this.liveBrokers = liveBrokers2;
    }

    public UpdateMetadataRequest(Struct struct) {
        super(struct);
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        for (Object partitionStateDataObj : struct.getArray(PARTITION_STATES_KEY_NAME)) {
            Struct partitionStateData = (Struct)partitionStateDataObj;
            String topic = partitionStateData.getString(TOPIC_KEY_NAME);
            int partition2 = partitionStateData.getInt(PARTITION_KEY_NAME);
            int controllerEpoch = partitionStateData.getInt(CONTROLLER_EPOCH_KEY_NAME);
            int leader = partitionStateData.getInt(LEADER_KEY_NAME);
            int leaderEpoch = partitionStateData.getInt(LEADER_EPOCH_KEY_NAME);
            Object[] isrArray = partitionStateData.getArray(ISR_KEY_NAME);
            ArrayList<Integer> isr = new ArrayList<Integer>(isrArray.length);
            for (Object r : isrArray) {
                isr.add((Integer)r);
            }
            int zkVersion = partitionStateData.getInt(ZK_VERSION_KEY_NAME);
            Object[] replicasArray = partitionStateData.getArray(REPLICAS_KEY_NAME);
            HashSet<Integer> replicas = new HashSet<Integer>(replicasArray.length);
            for (Object r : replicasArray) {
                replicas.add((Integer)r);
            }
            PartitionState partitionState = new PartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas);
            partitionStates.put(new TopicPartition(topic, partition2), partitionState);
        }
        HashSet<Broker> liveBrokers2 = new HashSet<Broker>();
        for (Object brokerDataObj : struct.getArray(LIVE_BROKERS_KEY_NAME)) {
            Struct brokerData = (Struct)brokerDataObj;
            int brokerId = brokerData.getInt(BROKER_ID_KEY_NAME);
            if (brokerData.hasField(HOST_KEY_NAME)) {
                String host = brokerData.getString(HOST_KEY_NAME);
                int port = brokerData.getInt(PORT_KEY_NAME);
                HashMap<SecurityProtocol, EndPoint> endPoints = new HashMap<SecurityProtocol, EndPoint>(1);
                endPoints.put(SecurityProtocol.PLAINTEXT, new EndPoint(host, port));
                liveBrokers2.add(new Broker(brokerId, endPoints));
                continue;
            }
            HashMap<SecurityProtocol, EndPoint> endPoints = new HashMap<SecurityProtocol, EndPoint>();
            for (Object endPointDataObj : brokerData.getArray(ENDPOINTS_KEY_NAME)) {
                Struct endPointData = (Struct)endPointDataObj;
                int port = endPointData.getInt(PORT_KEY_NAME);
                String host = endPointData.getString(HOST_KEY_NAME);
                short protocolTypeId = endPointData.getShort(SECURITY_PROTOCOL_TYPE_KEY_NAME);
                endPoints.put(SecurityProtocol.forId(protocolTypeId), new EndPoint(host, port));
            }
            liveBrokers2.add(new Broker(brokerId, endPoints));
        }
        this.controllerId = struct.getInt(CONTROLLER_ID_KEY_NAME);
        this.controllerEpoch = struct.getInt(CONTROLLER_EPOCH_KEY_NAME);
        this.partitionStates = partitionStates;
        this.liveBrokers = liveBrokers2;
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        switch (versionId) {
            case 0: 
            case 1: {
                return new UpdateMetadataResponse(Errors.forException(e).code());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.UPDATE_METADATA_KEY.id)));
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public Map<TopicPartition, PartitionState> partitionStates() {
        return this.partitionStates;
    }

    public Set<Broker> liveBrokers() {
        return this.liveBrokers;
    }

    public static UpdateMetadataRequest parse(ByteBuffer buffer, int versionId) {
        return new UpdateMetadataRequest(ProtoUtils.parseRequest(ApiKeys.UPDATE_METADATA_KEY.id, versionId, buffer));
    }

    public static UpdateMetadataRequest parse(ByteBuffer buffer) {
        return new UpdateMetadataRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }

    @Deprecated
    public static final class BrokerEndPoint {
        public final int id;
        public final String host;
        public final int port;

        public BrokerEndPoint(int id, String host, int port) {
            this.id = id;
            this.host = host;
            this.port = port;
        }
    }

    public static final class EndPoint {
        public final String host;
        public final int port;

        public EndPoint(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    public static final class Broker {
        public final int id;
        public final Map<SecurityProtocol, EndPoint> endPoints;

        public Broker(int id, Map<SecurityProtocol, EndPoint> endPoints) {
            this.id = id;
            this.endPoints = endPoints;
        }
    }

    public static final class PartitionState {
        public final int controllerEpoch;
        public final int leader;
        public final int leaderEpoch;
        public final List<Integer> isr;
        public final int zkVersion;
        public final Set<Integer> replicas;

        public PartitionState(int controllerEpoch, int leader, int leaderEpoch, List<Integer> isr, int zkVersion, Set<Integer> replicas) {
            this.controllerEpoch = controllerEpoch;
            this.leader = leader;
            this.leaderEpoch = leaderEpoch;
            this.isr = isr;
            this.zkVersion = zkVersion;
            this.replicas = replicas;
        }
    }
}

