/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack;

import org.graylog.shaded.mongojack4.org.mongojack.JacksonCollectionKey;
import org.graylog.shaded.mongojack4.org.mongojack.MongoCollection;
import org.graylog.shaded.mongojack4.org.mongojack.MongoJsonMappingException;

public class DBRef<T, K> {
    private final K id;
    private final Class<T> objectClass;
    private final String collectionName;
    private final String databaseName;

    public DBRef(K id, Class<T> objectClass, String collectionName, String databaseName) {
        this.id = id;
        this.objectClass = objectClass;
        this.collectionName = collectionName;
        this.databaseName = databaseName;
    }

    public DBRef(K id, Class<T> type) throws MongoJsonMappingException {
        this.id = id;
        this.objectClass = type;
        MongoCollection collection = type.getAnnotation(MongoCollection.class);
        if (collection == null) {
            throw new MongoJsonMappingException("Only types that have the @MongoCollection annotation on them can be used with this constructor");
        }
        this.collectionName = collection.name();
        this.databaseName = null;
    }

    public K getId() {
        return this.id;
    }

    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public JacksonCollectionKey<T> getCollectionKey() {
        return new JacksonCollectionKey<T>(this.databaseName, this.collectionName, this.objectClass);
    }
}

