/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack;

import com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.graylog.shaded.mongojack4.org.mongojack.MongoJackModuleFeature;

public class MongoJackModuleConfiguration {
    private final int moduleFeatures;

    public MongoJackModuleConfiguration() {
        this.moduleFeatures = MapperConfig.collectFeatureDefaults(MongoJackModuleFeature.class);
    }

    public MongoJackModuleConfiguration(int moduleFeatures) {
        this.moduleFeatures = moduleFeatures;
    }

    public final boolean isEnabled(MongoJackModuleFeature f) {
        return (this.moduleFeatures & f.getMask()) != 0;
    }

    public MongoJackModuleConfiguration with(MongoJackModuleFeature feature) {
        int newModuleFeatures = this.moduleFeatures | feature.getMask();
        return newModuleFeatures == this.moduleFeatures ? this : new MongoJackModuleConfiguration(newModuleFeatures);
    }

    public MongoJackModuleConfiguration with(MongoJackModuleFeature first, MongoJackModuleFeature ... features) {
        int newModuleFeatures = this.moduleFeatures | first.getMask();
        for (MongoJackModuleFeature f : features) {
            newModuleFeatures |= f.getMask();
        }
        return newModuleFeatures == this.moduleFeatures ? this : new MongoJackModuleConfiguration(newModuleFeatures);
    }

    public MongoJackModuleConfiguration withFeatures(MongoJackModuleFeature ... features) {
        int newModuleFeatures = this.moduleFeatures;
        for (MongoJackModuleFeature f : features) {
            newModuleFeatures |= f.getMask();
        }
        return newModuleFeatures == this.moduleFeatures ? this : new MongoJackModuleConfiguration(newModuleFeatures);
    }

    public MongoJackModuleConfiguration without(MongoJackModuleFeature feature) {
        int newModuleFeatures = this.moduleFeatures & ~feature.getMask();
        return newModuleFeatures == this.moduleFeatures ? this : new MongoJackModuleConfiguration(newModuleFeatures);
    }

    public MongoJackModuleConfiguration without(MongoJackModuleFeature first, MongoJackModuleFeature ... features) {
        int newModuleFeatures = this.moduleFeatures & ~first.getMask();
        for (MongoJackModuleFeature f : features) {
            newModuleFeatures &= ~f.getMask();
        }
        return newModuleFeatures == this.moduleFeatures ? this : new MongoJackModuleConfiguration(newModuleFeatures);
    }

    public MongoJackModuleConfiguration withoutFeatures(MongoJackModuleFeature ... features) {
        int newModuleFeatures = this.moduleFeatures;
        for (MongoJackModuleFeature f : features) {
            newModuleFeatures &= ~f.getMask();
        }
        return newModuleFeatures == this.moduleFeatures ? this : new MongoJackModuleConfiguration(newModuleFeatures);
    }
}

