/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import org.graylog.shaded.mongojack4.org.mongojack.internal.stream.DBEncoderBsonGenerator;

public abstract class TransformingEmbeddedObjectSerializer<InputType, TransformedType>
extends JsonSerializer<InputType> {
    protected final boolean writeNullAsNull;

    protected TransformingEmbeddedObjectSerializer() {
        this(false);
    }

    protected TransformingEmbeddedObjectSerializer(boolean writeNullAsNull) {
        this.writeNullAsNull = writeNullAsNull;
    }

    protected void writeEmbeddedObject(TransformedType value, JsonGenerator jgen) throws IOException {
        if (jgen instanceof DBEncoderBsonGenerator) {
            if (value == null && this.writeNullAsNull) {
                jgen.writeNull();
            } else {
                jgen.writeObject(value);
            }
        } else if (jgen instanceof TokenBuffer) {
            TokenBuffer buffer = (TokenBuffer)jgen;
            ObjectCodec codec = buffer.getCodec();
            buffer.setCodec(null);
            if (value == null && this.writeNullAsNull) {
                buffer.writeNull();
            } else {
                buffer.writeObject(value);
            }
            buffer.setCodec(codec);
        } else {
            String message = "JsonGenerator of type " + jgen.getClass().getName() + " not supported: " + ((Object)((Object)this)).getClass().getName() + " is designed for use only with " + DBEncoderBsonGenerator.class.getName() + " or " + TokenBuffer.class.getName();
            throw new IllegalArgumentException(message);
        }
    }

    protected abstract TransformedType transform(InputType var1);

    public void serialize(InputType value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        this.writeEmbeddedObject(this.transform(value), jgen);
    }
}

