/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.graylog.shaded.mongojack4.org.mongojack.MongoJackModuleConfiguration;
import org.graylog.shaded.mongojack4.org.mongojack.MongoJackModuleFeature;
import org.graylog.shaded.mongojack4.org.mongojack.internal.MongoAnnotationIntrospector;
import org.graylog.shaded.mongojack4.org.mongojack.internal.MongoJackDeserializers;
import org.graylog.shaded.mongojack4.org.mongojack.internal.MongoJackSerializers;

public class MongoJackModule
extends Module {
    public static final MongoJackModuleConfiguration DEFAULT_CONFIGURATION = new MongoJackModuleConfiguration();
    public static final Module DEFAULT_MODULE_INSTANCE = new MongoJackModule();
    public static final Module DEFAULT_JAVA_TIME_MODULE = new JavaTimeModule();
    private final MongoJackModuleConfiguration moduleConfiguration;

    public MongoJackModule() {
        this.moduleConfiguration = DEFAULT_CONFIGURATION;
    }

    public MongoJackModule(MongoJackModuleConfiguration moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }

    public static ObjectMapper configure(ObjectMapper objectMapper) {
        return MongoJackModule.configure(objectMapper, DEFAULT_CONFIGURATION);
    }

    public static ObjectMapper configure(ObjectMapper objectMapper, MongoJackModuleConfiguration moduleConfiguration) {
        if (moduleConfiguration.isEnabled(MongoJackModuleFeature.REGISTER_JAVA_TIME)) {
            objectMapper.registerModule(DEFAULT_JAVA_TIME_MODULE);
        }
        if (moduleConfiguration == DEFAULT_CONFIGURATION) {
            objectMapper.registerModule(DEFAULT_MODULE_INSTANCE);
        } else {
            objectMapper.registerModule((Module)new MongoJackModule(moduleConfiguration));
        }
        if (moduleConfiguration.isEnabled(MongoJackModuleFeature.DISABLE_DATES_AS_TIMESTAMPS)) {
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        }
        if (moduleConfiguration.isEnabled(MongoJackModuleFeature.SET_SERIALIZATION_INCLUSION_NON_NULL)) {
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        return objectMapper;
    }

    public String getModuleName() {
        return "Object ID Module";
    }

    public Version version() {
        return new Version(1, 0, 0, null, "org.graylog.shaded.mongojack4.org.mongojack", "mongojack");
    }

    public void setupModule(Module.SetupContext context) {
        MongoAnnotationIntrospector annotationIntrospector = new MongoAnnotationIntrospector(context.getTypeFactory());
        context.insertAnnotationIntrospector((AnnotationIntrospector)annotationIntrospector);
        context.addSerializers((Serializers)new MongoJackSerializers(this.moduleConfiguration));
        context.addDeserializers((Deserializers)new MongoJackDeserializers());
    }
}

