/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal;

import com.fasterxml.jackson.databind.module.SimpleSerializers;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.bson.types.ObjectId;
import org.graylog.shaded.mongojack4.org.mongojack.MongoJackModuleConfiguration;
import org.graylog.shaded.mongojack4.org.mongojack.MongoJackModuleFeature;
import org.graylog.shaded.mongojack4.org.mongojack.internal.CalendarSerializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.DBRefSerializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.DateSerializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.MongoDBRefSerializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.MongoJackInstantSerializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.MongoJackModule;
import org.graylog.shaded.mongojack4.org.mongojack.internal.ObjectIdSerializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.UUIDSerializer;

public class MongoJackSerializers
extends SimpleSerializers {
    public MongoJackSerializers() {
        this(MongoJackModule.DEFAULT_CONFIGURATION);
    }

    public MongoJackSerializers(MongoJackModuleConfiguration moduleConfiguration) {
        this.addSerializer(new DBRefSerializer());
        this.addSerializer(new MongoDBRefSerializer());
        this.addSerializer(ObjectId.class, new ObjectIdSerializer());
        this.addSerializer(Date.class, new DateSerializer());
        this.addSerializer(Calendar.class, new CalendarSerializer());
        if (moduleConfiguration.isEnabled(MongoJackModuleFeature.WRITE_INSTANT_AS_BSON_DATE)) {
            this.addSerializer(Instant.class, new MongoJackInstantSerializer());
        }
        this.addSerializer(UUID.class, new UUIDSerializer());
    }
}

