/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal.stream;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bson.BsonBinary;
import org.bson.BsonWriter;
import org.bson.UuidRepresentation;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class JsonGeneratorAdapter
extends GeneratorBase {
    protected final BsonWriter writer;
    protected final UuidRepresentation uuidRepresentation;

    protected JsonGeneratorAdapter(int features, ObjectCodec codec, BsonWriter writer, UuidRepresentation uuidRepresentation) {
        super(features, codec);
        this.writer = writer;
        this.uuidRepresentation = uuidRepresentation;
    }

    protected JsonGeneratorAdapter(int features, ObjectCodec codec, JsonWriteContext ctxt, BsonWriter writer, UuidRepresentation uuidRepresentation) {
        super(features, codec, ctxt);
        this.writer = writer;
        this.uuidRepresentation = uuidRepresentation;
    }

    public void writeStartArray() throws IOException {
        this.writer.writeStartArray();
    }

    public void writeEndArray() throws IOException {
        this.writer.writeEndArray();
    }

    public void writeStartObject() throws IOException {
        this.writer.writeStartDocument();
    }

    public void writeEndObject() throws IOException {
        this.writer.writeEndDocument();
    }

    public void writeFieldName(String name) throws IOException {
        this.writer.writeName(name);
    }

    public void writeString(String text) throws IOException {
        this.writer.writeString(text);
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.writer.writeString(new String(text, offset, len));
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        this.writer.writeString(new String(text, offset, length, StandardCharsets.UTF_8));
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        this.writer.writeString(new String(text, offset, length, StandardCharsets.UTF_8));
    }

    public void writeRaw(String text) throws IOException {
        throw new UnsupportedOperationException("writeRaw not supported");
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException("writeRaw not supported");
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException("writeRaw not supported");
    }

    public void writeRaw(char c) throws IOException {
        throw new UnsupportedOperationException("writeRaw not supported");
    }

    public void writeBinary(Base64Variant bv, byte[] data, int offset, int len) throws IOException {
        this.writer.writeBinaryData(new BsonBinary(Arrays.copyOfRange(data, offset, len)));
    }

    public void writeNumber(int v) throws IOException {
        this.writer.writeInt32(v);
    }

    public void writeNumber(long v) throws IOException {
        this.writer.writeInt64(v);
    }

    public void writeNumber(BigInteger v) throws IOException {
        int bl = v.bitLength();
        if (bl < 32) {
            this.writeNumber(v.intValue());
        } else if (bl < 64) {
            this.writeNumber(v.longValue());
        } else {
            this.writeString(v.toString());
        }
    }

    public void writeNumber(double v) throws IOException {
        this.writer.writeDouble(v);
    }

    public void writeNumber(float v) throws IOException {
        this.writeNumber((double)v);
    }

    public void writeNumber(BigDecimal v) throws IOException {
        this.writer.writeDecimal128(new Decimal128(v));
    }

    public void writeNumber(String encodedValue) throws IOException {
        this.writeString(encodedValue);
    }

    public void writeBoolean(boolean state) throws IOException {
        this.writer.writeBoolean(state);
    }

    public void writeNull() throws IOException {
        this.writer.writeNull();
    }

    public void writeBsonObjectId(ObjectId objectId) {
        this.writer.writeObjectId(objectId);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    protected void _releaseBuffers() {
        this.writer.flush();
    }

    protected void _verifyValueWrite(String typeMsg) throws IOException {
    }
}

