/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal;

import com.fasterxml.jackson.databind.introspect.Annotated;
import org.mongojack.Id;

public class AnnotationHelper {
    private static final Class<?> JAVAX_PERSIST_ID_CLASS = AnnotationHelper.initPersistIdClass("javax.persistence.Id");
    private static final Class<?> JAKARTA_PERSIST_ID_CLASS = AnnotationHelper.initPersistIdClass("jakarta.persistence.Id");

    private AnnotationHelper() {
    }

    public static boolean hasIdAnnotation(Annotated annotated) {
        return annotated.hasAnnotation(Id.class) || JAVAX_PERSIST_ID_CLASS != null && annotated.hasAnnotation(JAVAX_PERSIST_ID_CLASS) || JAKARTA_PERSIST_ID_CLASS != null && annotated.hasAnnotation(JAKARTA_PERSIST_ID_CLASS);
    }

    private static Class<?> initPersistIdClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

