/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import org.graylog.shaded.mongojack4.org.mongojack.DBRef;
import org.graylog.shaded.mongojack4.org.mongojack.internal.AnnotationHelper;
import org.graylog.shaded.mongojack4.org.mongojack.internal.DBRefDeserializer;
import org.graylog.shaded.mongojack4.org.mongojack.internal.ObjectIdDeserializers;
import org.graylog.shaded.mongojack4.org.mongojack.internal.ObjectIdSerializer;
import org.mongojack.ObjectId;

public class MongoAnnotationIntrospector
extends NopAnnotationIntrospector {
    private final TypeFactory typeFactory;

    public MongoAnnotationIntrospector(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        String rawName = this.findPropertyName(a);
        if (rawName != null) {
            return new PropertyName(rawName);
        }
        return null;
    }

    public PropertyName findNameForSerialization(Annotated a) {
        String rawName = this.findPropertyName(a);
        if (rawName != null) {
            return new PropertyName(rawName);
        }
        return null;
    }

    private String findPropertyName(Annotated annotated) {
        return AnnotationHelper.hasIdAnnotation(annotated) ? "_id" : null;
    }

    private Type getTypeForAnnotated(Annotated a) {
        if (a instanceof AnnotatedMethod) {
            return ((AnnotatedMethod)a).getParameterType(0);
        }
        return a.getType();
    }

    public Object findSerializer(Annotated am) {
        if (am.hasAnnotation(ObjectId.class)) {
            return ObjectIdSerializer.class;
        }
        return null;
    }

    public Object findDeserializer(Annotated am) {
        if (am.hasAnnotation(ObjectId.class)) {
            return this.findObjectIdDeserializer(this.typeFactory.constructType(this.getTypeForAnnotated(am)));
        }
        return null;
    }

    public JsonDeserializer findContentDeserializer(Annotated am) {
        if (am.hasAnnotation(ObjectId.class)) {
            JavaType type = this.typeFactory.constructType(this.getTypeForAnnotated(am));
            if (type.isCollectionLikeType()) {
                return this.findObjectIdDeserializer(type.containedType(0));
            }
            if (type.isMapLikeType()) {
                return this.findObjectIdDeserializer(type.containedType(1));
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonDeserializer findObjectIdDeserializer(JavaType type) {
        if (type.getRawClass() == String.class) {
            return new ObjectIdDeserializers.ToStringDeserializer();
        }
        if (type.getRawClass() == byte[].class) {
            return new ObjectIdDeserializers.ToByteArrayDeserializer();
        }
        if (type.getRawClass() == DBRef.class) {
            JavaType dbRefType;
            if (type.isContainerType()) {
                if (type.isCollectionLikeType()) {
                    dbRefType = type.containedType(0);
                } else {
                    if (!type.isMapLikeType()) return null;
                    dbRefType = type.containedType(1);
                }
            } else {
                dbRefType = type;
            }
            JsonDeserializer keyDeserializer = this.findObjectIdDeserializer(dbRefType.containedType(1));
            return new DBRefDeserializer(dbRefType.containedType(0), dbRefType.containedType(1), keyDeserializer);
        }
        if (type.getRawClass() != org.bson.types.ObjectId.class) return null;
        return new ObjectIdDeserializers.ToObjectIdDeserializer();
    }
}

