/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.UUID;
import org.bson.BsonBinary;

public class UUIDDeserializer
extends JsonDeserializer<UUID> {
    public UUID deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken token = jp.getCurrentToken();
        if (token == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jp.getEmbeddedObject();
            if (object instanceof UUID) {
                return (UUID)object;
            }
            if (object instanceof BsonBinary) {
                return ((BsonBinary)object).asUuid();
            }
        }
        return (UUID)ctxt.handleUnexpectedToken(UUID.class, jp);
    }
}

