/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal.stream;

import com.fasterxml.jackson.core.JsonGenerator;
import com.mongodb.DBRef;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.bson.BsonBinary;
import org.bson.BsonWriter;
import org.bson.UuidRepresentation;
import org.bson.types.ObjectId;
import org.graylog.shaded.mongojack4.org.mongojack.internal.stream.JsonGeneratorAdapter;
import org.graylog.shaded.mongojack4.org.mongojack.internal.util.DocumentSerializationUtils;

public class DBEncoderBsonGenerator
extends JsonGeneratorAdapter {
    public DBEncoderBsonGenerator(int jsonFeatures, BsonWriter out, UuidRepresentation uuidRepresentation) {
        super(jsonFeatures, null, out, uuidRepresentation);
    }

    public DBEncoderBsonGenerator(BsonWriter writer, UuidRepresentation uuidRepresentation) {
        this(JsonGenerator.Feature.collectDefaults(), writer, uuidRepresentation);
    }

    protected void _writeSimpleObject(Object value) throws IOException {
        if (value instanceof Date) {
            this.writer.writeDateTime(((Date)value).getTime());
        } else if (value instanceof Calendar) {
            this.writer.writeDateTime(((Calendar)value).getTime().getTime());
        } else if (value instanceof ObjectId) {
            this.writeBsonObjectId((ObjectId)value);
        } else if (value instanceof UUID) {
            this.writer.writeBinaryData(new BsonBinary((UUID)value, this.uuidRepresentation));
        } else if (value instanceof DBRef) {
            DBRef dbRef = (DBRef)value;
            this.writeStartObject();
            this.writeFieldName("$ref");
            this.writeString(dbRef.getCollectionName());
            this.writeFieldName("$id");
            this.writeObject(dbRef.getId());
            if (dbRef.getDatabaseName() != null) {
                this.writeFieldName("$db");
                this.writeString(dbRef.getDatabaseName());
            }
            this.writeEndObject();
        } else if (!DocumentSerializationUtils.writeKnownType(value, this.writer)) {
            super._writeSimpleObject(value);
        }
    }
}

