/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.mongojack4.org.mongojack.internal.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.Function;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.graylog.shaded.mongojack4.org.mongojack.InitializationRequiredForTransformation;
import org.graylog.shaded.mongojack4.org.mongojack.JacksonCodecRegistry;
import org.graylog.shaded.mongojack4.org.mongojack.SerializationOptions;
import org.graylog.shaded.mongojack4.org.mongojack.internal.util.DocumentSerializationUtils;

public class DistinctIterableDecorator<TResult>
implements DistinctIterable<TResult> {
    private final DistinctIterable<TResult> delegate;
    private final ObjectMapper objectMapper;
    private final JavaType type;
    private final JacksonCodecRegistry codecRegistry;
    private final SerializationOptions serializationOptions;

    public DistinctIterableDecorator(DistinctIterable<TResult> delegate, ObjectMapper objectMapper, JavaType type, JacksonCodecRegistry codecRegistry, SerializationOptions serializationOptions) {
        this.delegate = delegate;
        this.objectMapper = objectMapper;
        this.type = type;
        this.codecRegistry = codecRegistry;
        this.serializationOptions = serializationOptions;
    }

    public DistinctIterable<TResult> filter(Bson filter) {
        if (filter instanceof InitializationRequiredForTransformation) {
            ((InitializationRequiredForTransformation)filter).initialize(this.objectMapper, this.type, this.codecRegistry);
            return this.delegate.filter(filter);
        }
        if (this.serializationOptions.isSimpleFilterSerialization()) {
            return this.delegate.filter(filter);
        }
        return this.delegate.filter(DocumentSerializationUtils.serializeFilter(this.objectMapper, this.type, filter, this.codecRegistry));
    }

    public DistinctIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        return this.delegate.maxTime(maxTime, timeUnit);
    }

    public DistinctIterable<TResult> batchSize(int batchSize) {
        return this.delegate.batchSize(batchSize);
    }

    public DistinctIterable<TResult> collation(Collation collation) {
        return this.delegate.collation(collation);
    }

    public DistinctIterable<TResult> comment(String s) {
        return this.delegate.comment(s);
    }

    public DistinctIterable<TResult> comment(BsonValue bsonValue) {
        return this.delegate.comment(bsonValue);
    }

    public MongoCursor<TResult> iterator() {
        return this.delegate.iterator();
    }

    public MongoCursor<TResult> cursor() {
        return this.delegate.cursor();
    }

    @Nullable
    public TResult first() {
        return (TResult)this.delegate.first();
    }

    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return this.delegate.map(mapper);
    }

    public <A extends Collection<? super TResult>> A into(A target) {
        return (A)this.delegate.into(target);
    }

    public void forEach(Consumer<? super TResult> action) {
        this.delegate.forEach(action);
    }

    public Spliterator<TResult> spliterator() {
        return this.delegate.spliterator();
    }
}

