/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.github.mustachejava.resolver;

import java.io.File;
import java.io.Reader;
import org.graylog.shaded.opensearch2.com.github.mustachejava.MustacheResolver;
import org.graylog.shaded.opensearch2.com.github.mustachejava.resolver.ClasspathResolver;
import org.graylog.shaded.opensearch2.com.github.mustachejava.resolver.FileSystemResolver;
import org.graylog.shaded.opensearch2.com.github.mustachejava.resolver.URIResolver;

public class DefaultResolver
implements MustacheResolver {
    private final ClasspathResolver classpathResolver;
    private final FileSystemResolver fileSystemResolver;
    private final URIResolver uriResolver;

    public DefaultResolver() {
        this.fileSystemResolver = new FileSystemResolver();
        this.classpathResolver = new ClasspathResolver();
        this.uriResolver = new URIResolver();
    }

    public DefaultResolver(String resourceRoot) {
        this.classpathResolver = new ClasspathResolver(resourceRoot);
        this.fileSystemResolver = new FileSystemResolver();
        this.uriResolver = new URIResolver();
    }

    public DefaultResolver(File fileRoot) {
        this.fileSystemResolver = new FileSystemResolver(fileRoot);
        this.classpathResolver = new ClasspathResolver();
        this.uriResolver = new URIResolver();
    }

    @Override
    public Reader getReader(String resourceName) {
        Reader reader = this.classpathResolver.getReader(resourceName);
        if (reader == null && (reader = this.fileSystemResolver.getReader(resourceName)) == null) {
            reader = this.uriResolver.getReader(resourceName);
        }
        return reader;
    }
}

