/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.ReusableStringReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Tokenizer;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.AttributeFactory;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.CloseableThreadLocal;

public abstract class Analyzer
implements Closeable {
    private final ReuseStrategy reuseStrategy;
    CloseableThreadLocal<Object> storedValue = new CloseableThreadLocal();
    public static final ReuseStrategy GLOBAL_REUSE_STRATEGY = new ReuseStrategy(){

        @Override
        public TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            return (TokenStreamComponents)this.getStoredValue(analyzer);
        }

        @Override
        public void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
            this.setStoredValue(analyzer, components);
        }
    };
    public static final ReuseStrategy PER_FIELD_REUSE_STRATEGY = new ReuseStrategy(){

        @Override
        public TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            Map componentsPerField = (Map)this.getStoredValue(analyzer);
            return componentsPerField != null ? (TokenStreamComponents)componentsPerField.get(fieldName) : null;
        }

        @Override
        public void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
            HashMap<String, TokenStreamComponents> componentsPerField = (HashMap<String, TokenStreamComponents>)this.getStoredValue(analyzer);
            if (componentsPerField == null) {
                componentsPerField = new HashMap<String, TokenStreamComponents>();
                this.setStoredValue(analyzer, componentsPerField);
            }
            componentsPerField.put(fieldName, components);
        }
    };

    protected Analyzer() {
        this(GLOBAL_REUSE_STRATEGY);
    }

    protected Analyzer(ReuseStrategy reuseStrategy) {
        this.reuseStrategy = reuseStrategy;
    }

    protected abstract TokenStreamComponents createComponents(String var1);

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return in;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStreamComponents components = this.reuseStrategy.getReusableComponents(this, fieldName);
        Reader r = this.initReader(fieldName, reader);
        if (components == null) {
            components = this.createComponents(fieldName);
            this.reuseStrategy.setReusableComponents(this, fieldName, components);
        }
        components.setReader(r);
        return components.getTokenStream();
    }

    public final TokenStream tokenStream(String fieldName, String text) {
        TokenStreamComponents components = this.reuseStrategy.getReusableComponents(this, fieldName);
        ReusableStringReader strReader = components == null || components.reusableStringReader == null ? new ReusableStringReader() : components.reusableStringReader;
        strReader.setValue(text);
        Reader r = this.initReader(fieldName, strReader);
        if (components == null) {
            components = this.createComponents(fieldName);
            this.reuseStrategy.setReusableComponents(this, fieldName, components);
        }
        components.setReader(r);
        components.reusableStringReader = strReader;
        return components.getTokenStream();
    }

    public final BytesRef normalize(String fieldName, String text) {
        BytesRef bytesRef;
        block19: {
            String filteredText;
            try (StringReader reader = new StringReader(text);){
                int read;
                Reader filterReader = this.initReaderForNormalization(fieldName, reader);
                char[] buffer = new char[64];
                StringBuilder builder = new StringBuilder();
                while ((read = filterReader.read(buffer, 0, buffer.length)) != -1) {
                    builder.append(buffer, 0, read);
                }
                filteredText = builder.toString();
            }
            catch (IOException e) {
                throw new IllegalStateException("Normalization threw an unexpected exception", e);
            }
            AttributeFactory attributeFactory = this.attributeFactory(fieldName);
            TokenStream ts = this.normalize(fieldName, new StringTokenStream(attributeFactory, filteredText, text.length()));
            try {
                TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
                ts.reset();
                if (!ts.incrementToken()) {
                    throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer " + this + " and input \"" + text + "\"");
                }
                BytesRef term = BytesRef.deepCopyOf(termAtt.getBytesRef());
                if (ts.incrementToken()) {
                    throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 2+ for analyzer " + this + " and input \"" + text + "\"");
                }
                ts.end();
                bytesRef = term;
                if (ts == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (ts != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Normalization threw an unexpected exception", e);
                }
            }
            ts.close();
        }
        return bytesRef;
    }

    protected Reader initReader(String fieldName, Reader reader) {
        return reader;
    }

    protected Reader initReaderForNormalization(String fieldName, Reader reader) {
        return reader;
    }

    protected AttributeFactory attributeFactory(String fieldName) {
        return TokenStream.DEFAULT_TOKEN_ATTRIBUTE_FACTORY;
    }

    public int getPositionIncrementGap(String fieldName) {
        return 0;
    }

    public int getOffsetGap(String fieldName) {
        return 1;
    }

    public final ReuseStrategy getReuseStrategy() {
        return this.reuseStrategy;
    }

    @Override
    public void close() {
        if (this.storedValue != null) {
            this.storedValue.close();
            this.storedValue = null;
        }
    }

    private static final class StringTokenStream
    extends TokenStream {
        private final String value;
        private final int length;
        private boolean used = true;
        private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);

        StringTokenStream(AttributeFactory attributeFactory, String value, int length) {
            super(attributeFactory);
            this.value = value;
            this.length = length;
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.termAttribute.append(this.value);
            this.offsetAttribute.setOffset(0, this.length);
            this.used = true;
            return true;
        }

        @Override
        public void end() throws IOException {
            super.end();
            this.offsetAttribute.setOffset(this.length, this.length);
        }
    }

    public static abstract class ReuseStrategy {
        protected ReuseStrategy() {
        }

        public abstract TokenStreamComponents getReusableComponents(Analyzer var1, String var2);

        public abstract void setReusableComponents(Analyzer var1, String var2, TokenStreamComponents var3);

        protected final Object getStoredValue(Analyzer analyzer) {
            if (analyzer.storedValue == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            return analyzer.storedValue.get();
        }

        protected final void setStoredValue(Analyzer analyzer, Object storedValue) {
            if (analyzer.storedValue == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            analyzer.storedValue.set(storedValue);
        }
    }

    public static final class TokenStreamComponents {
        protected final Consumer<Reader> source;
        protected final TokenStream sink;
        transient ReusableStringReader reusableStringReader;

        public TokenStreamComponents(Consumer<Reader> source, TokenStream result) {
            this.source = source;
            this.sink = result;
        }

        public TokenStreamComponents(Tokenizer tokenizer, TokenStream result) {
            this(tokenizer::setReader, result);
        }

        public TokenStreamComponents(Tokenizer tokenizer) {
            this(tokenizer::setReader, (TokenStream)tokenizer);
        }

        private void setReader(Reader reader) {
            this.source.accept(reader);
        }

        public TokenStream getTokenStream() {
            return this.sink;
        }

        public Consumer<Reader> getSource() {
            return this.source;
        }
    }
}

