/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.charfilter;

import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.CharFilterFactory;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;

public class HTMLStripCharFilterFactory
extends CharFilterFactory {
    public static final String NAME = "htmlStrip";
    final Set<String> escapedTags;
    static final Pattern TAG_NAME_PATTERN = Pattern.compile("[^\\s,]+");

    public HTMLStripCharFilterFactory(Map<String, String> args) {
        super(args);
        this.escapedTags = this.getSet(args, "escapedTags");
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public HTMLStripCharFilterFactory() {
        throw HTMLStripCharFilterFactory.defaultCtorException();
    }

    @Override
    public HTMLStripCharFilter create(Reader input) {
        HTMLStripCharFilter charFilter = null == this.escapedTags ? new HTMLStripCharFilter(input) : new HTMLStripCharFilter(input, this.escapedTags);
        return charFilter;
    }
}

