/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.miscellaneous;

import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.FilteringTokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class LengthFilter
extends FilteringTokenFilter {
    private final int min;
    private final int max;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public LengthFilter(TokenStream in, int min, int max) {
        super(in);
        if (min < 0) {
            throw new IllegalArgumentException("minimum length must be greater than or equal to zero");
        }
        if (min > max) {
            throw new IllegalArgumentException("maximum length must not be greater than minimum length");
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean accept() {
        int len = this.termAtt.length();
        return len >= this.min && len <= this.max;
    }
}

