/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.compressing;

import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergeState;

public class MatchingReaders {
    public final boolean[] matchingReaders;
    final int count;

    public MatchingReaders(MergeState mergeState) {
        int numReaders = mergeState.maxDocs.length;
        int matchedCount = 0;
        this.matchingReaders = new boolean[numReaders];
        block0: for (int i = 0; i < numReaders; ++i) {
            for (FieldInfo fi : mergeState.fieldInfos[i]) {
                FieldInfo other = mergeState.mergeFieldInfos.fieldInfo(fi.number);
                if (other != null && other.name.equals(fi.name)) continue;
                continue block0;
            }
            this.matchingReaders[i] = true;
            ++matchedCount;
        }
        this.count = matchedCount;
        if (mergeState.infoStream.isEnabled("SM")) {
            mergeState.infoStream.message("SM", "merge store matchedCount=" + this.count + " vs " + numReaders);
            if (this.count != numReaders) {
                mergeState.infoStream.message("SM", numReaders - this.count + " non-bulk merges");
            }
        }
    }
}

