/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene80;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene80.IndexedDISI;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene80.Lucene80DocValuesFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.packed.LegacyDirectMonotonicReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.packed.LegacyDirectReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.DocValuesProducer;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.BaseTermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.BinaryDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.CorruptIndexException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ImpactsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexFileNames;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PostingsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentReadState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ByteArrayDataInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ChecksumIndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.DataInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.RandomAccessInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.LongValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.compress.LZ4;

final class Lucene80DocValuesProducer
extends DocValuesProducer {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, SortedEntry> sorted;
    private final Map<String, SortedSetEntry> sortedSets;
    private final Map<String, SortedNumericEntry> sortedNumerics;
    private final IndexInput data;
    private final int maxDoc;
    private int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene80DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        block14: {
            this.numerics = new HashMap<String, NumericEntry>();
            this.binaries = new HashMap<String, BinaryEntry>();
            this.sorted = new HashMap<String, SortedEntry>();
            this.sortedSets = new HashMap<String, SortedSetEntry>();
            this.sortedNumerics = new HashMap<String, SortedNumericEntry>();
            this.version = -1;
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.maxDoc = state.segmentInfo.maxDoc();
            try (ChecksumIndexInput in = EndiannessReverserUtil.openChecksumInput(state.directory, metaName, state.context);){
                Throwable priorE = null;
                try {
                    this.version = CodecUtil.checkIndexHeader(in, metaCodec, 0, 2, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(state.segmentInfo.name, in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(in, priorE);
                    }
                }
                CodecUtil.checkFooter(in, priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = EndiannessReverserUtil.openInput(state.directory, dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader(this.data, dataCodec, 0, 2, state.segmentInfo.getId(), state.segmentSuffix);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + this.version + ", data=" + version2, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private void readFields(String segmentName, IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(info.name, this.readNumeric(meta));
            } else if (type == 1) {
                boolean compressed;
                if (this.version >= 2) {
                    String value = info.getAttribute(Lucene80DocValuesFormat.MODE_KEY);
                    if (value == null) {
                        throw new IllegalStateException("missing value for " + Lucene80DocValuesFormat.MODE_KEY + " for field: " + info.name + " in segment: " + segmentName);
                    }
                    Lucene80DocValuesFormat.Mode mode = Lucene80DocValuesFormat.Mode.valueOf(value);
                    compressed = mode == Lucene80DocValuesFormat.Mode.BEST_COMPRESSION;
                } else {
                    compressed = this.version >= 1;
                }
                this.binaries.put(info.name, this.readBinary(meta, compressed));
            } else if (type == 2) {
                this.sorted.put(info.name, this.readSorted(meta));
            } else if (type == 3) {
                this.sortedSets.put(info.name, this.readSortedSet(meta));
            } else if (type == 4) {
                this.sortedNumerics.put(info.name, this.readSortedNumeric(meta));
            } else {
                throw new CorruptIndexException("invalid type: " + type, meta);
            }
            fieldNumber = meta.readInt();
        }
    }

    private NumericEntry readNumeric(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        this.readNumeric(meta, entry);
        return entry;
    }

    private void readNumeric(IndexInput meta, NumericEntry entry) throws IOException {
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.jumpTableEntryCount = meta.readShort();
        entry.denseRankPower = meta.readByte();
        entry.numValues = meta.readLong();
        int tableSize = meta.readInt();
        if (tableSize > 256) {
            throw new CorruptIndexException("invalid table size: " + tableSize, meta);
        }
        if (tableSize >= 0) {
            entry.table = new long[tableSize];
            for (int i = 0; i < tableSize; ++i) {
                entry.table[i] = meta.readLong();
            }
        }
        entry.blockShift = tableSize < -1 ? -2 - tableSize : -1;
        entry.bitsPerValue = meta.readByte();
        entry.minValue = meta.readLong();
        entry.gcd = meta.readLong();
        entry.valuesOffset = meta.readLong();
        entry.valuesLength = meta.readLong();
        entry.valueJumpTableOffset = meta.readLong();
    }

    private BinaryEntry readBinary(IndexInput meta, boolean compressed) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.compressed = compressed;
        entry.dataOffset = meta.readLong();
        entry.dataLength = meta.readLong();
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.jumpTableEntryCount = meta.readShort();
        entry.denseRankPower = meta.readByte();
        entry.numDocsWithField = meta.readInt();
        entry.minLength = meta.readInt();
        entry.maxLength = meta.readInt();
        if (entry.compressed && entry.numDocsWithField > 0 || entry.minLength < entry.maxLength) {
            entry.addressesOffset = meta.readLong();
            long numAddresses = (long)entry.numDocsWithField + 1L;
            if (entry.compressed) {
                entry.numCompressedChunks = meta.readVInt();
                entry.docsPerChunkShift = meta.readVInt();
                entry.maxUncompressedChunkSize = meta.readVInt();
                numAddresses = entry.numCompressedChunks;
            }
            int blockShift = meta.readVInt();
            entry.addressesMeta = LegacyDirectMonotonicReader.loadMeta(meta, numAddresses, blockShift);
            entry.addressesLength = meta.readLong();
        }
        return entry;
    }

    private SortedEntry readSorted(IndexInput meta) throws IOException {
        SortedEntry entry = new SortedEntry();
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.jumpTableEntryCount = meta.readShort();
        entry.denseRankPower = meta.readByte();
        entry.numDocsWithField = meta.readInt();
        entry.bitsPerValue = meta.readByte();
        entry.ordsOffset = meta.readLong();
        entry.ordsLength = meta.readLong();
        Lucene80DocValuesProducer.readTermDict(meta, entry);
        return entry;
    }

    private SortedSetEntry readSortedSet(IndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        byte multiValued = meta.readByte();
        switch (multiValued) {
            case 0: {
                entry.singleValueEntry = this.readSorted(meta);
                return entry;
            }
            case 1: {
                break;
            }
            default: {
                throw new CorruptIndexException("Invalid multiValued flag: " + multiValued, meta);
            }
        }
        entry.docsWithFieldOffset = meta.readLong();
        entry.docsWithFieldLength = meta.readLong();
        entry.jumpTableEntryCount = meta.readShort();
        entry.denseRankPower = meta.readByte();
        entry.bitsPerValue = meta.readByte();
        entry.ordsOffset = meta.readLong();
        entry.ordsLength = meta.readLong();
        entry.numDocsWithField = meta.readInt();
        entry.addressesOffset = meta.readLong();
        int blockShift = meta.readVInt();
        entry.addressesMeta = LegacyDirectMonotonicReader.loadMeta(meta, entry.numDocsWithField + 1, blockShift);
        entry.addressesLength = meta.readLong();
        Lucene80DocValuesProducer.readTermDict(meta, entry);
        return entry;
    }

    private static void readTermDict(IndexInput meta, TermsDictEntry entry) throws IOException {
        entry.termsDictSize = meta.readVLong();
        int termsDictBlockCode = meta.readInt();
        if (393217 == termsDictBlockCode) {
            entry.compressed = true;
            entry.termsDictBlockShift = 6;
        } else {
            entry.termsDictBlockShift = termsDictBlockCode;
        }
        int blockShift = meta.readInt();
        long addressesSize = entry.termsDictSize + (1L << entry.termsDictBlockShift) - 1L >>> entry.termsDictBlockShift;
        entry.termsAddressesMeta = LegacyDirectMonotonicReader.loadMeta(meta, addressesSize, blockShift);
        entry.maxTermLength = meta.readInt();
        if (entry.compressed) {
            entry.maxBlockLength = meta.readInt();
        }
        entry.termsDataOffset = meta.readLong();
        entry.termsDataLength = meta.readLong();
        entry.termsAddressesOffset = meta.readLong();
        entry.termsAddressesLength = meta.readLong();
        entry.termsDictIndexShift = meta.readInt();
        long indexSize = entry.termsDictSize + (1L << entry.termsDictIndexShift) - 1L >>> entry.termsDictIndexShift;
        entry.termsIndexAddressesMeta = LegacyDirectMonotonicReader.loadMeta(meta, 1L + indexSize, blockShift);
        entry.termsIndexOffset = meta.readLong();
        entry.termsIndexLength = meta.readLong();
        entry.termsIndexAddressesOffset = meta.readLong();
        entry.termsIndexAddressesLength = meta.readLong();
    }

    private SortedNumericEntry readSortedNumeric(IndexInput meta) throws IOException {
        SortedNumericEntry entry = new SortedNumericEntry();
        this.readNumeric(meta, entry);
        entry.numDocsWithField = meta.readInt();
        if ((long)entry.numDocsWithField != entry.numValues) {
            entry.addressesOffset = meta.readLong();
            int blockShift = meta.readVInt();
            entry.addressesMeta = LegacyDirectMonotonicReader.loadMeta(meta, entry.numDocsWithField + 1, blockShift);
            entry.addressesLength = meta.readLong();
        }
        return entry;
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.name);
        return this.getNumeric(entry);
    }

    private NumericDocValues getNumeric(final NumericEntry entry) throws IOException {
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyNumeric();
        }
        if (entry.docsWithFieldOffset == -1L) {
            if (entry.bitsPerValue == 0) {
                return new DenseNumericDocValues(this.maxDoc){

                    @Override
                    public long longValue() throws IOException {
                        return entry.minValue;
                    }
                };
            }
            final RandomAccessInput slice = this.data.randomAccessSlice(entry.valuesOffset, entry.valuesLength);
            if (entry.blockShift >= 0) {
                return new DenseNumericDocValues(this.maxDoc){
                    final VaryingBPVReader vBPVReader;
                    {
                        super(maxDoc);
                        this.vBPVReader = new VaryingBPVReader(entry, slice);
                    }

                    @Override
                    public long longValue() throws IOException {
                        return this.vBPVReader.getLongValue(this.doc);
                    }
                };
            }
            final LongValues values = LegacyDirectReader.getInstance(slice, entry.bitsPerValue);
            if (entry.table != null) {
                final long[] table = entry.table;
                return new DenseNumericDocValues(this.maxDoc){

                    @Override
                    public long longValue() throws IOException {
                        return table[(int)values.get(this.doc)];
                    }
                };
            }
            final long mul = entry.gcd;
            final long delta = entry.minValue;
            return new DenseNumericDocValues(this.maxDoc){

                @Override
                public long longValue() throws IOException {
                    return mul * values.get(this.doc) + delta;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numValues);
        if (entry.bitsPerValue == 0) {
            return new SparseNumericDocValues(disi){

                @Override
                public long longValue() throws IOException {
                    return entry.minValue;
                }
            };
        }
        final RandomAccessInput slice = this.data.randomAccessSlice(entry.valuesOffset, entry.valuesLength);
        if (entry.blockShift >= 0) {
            return new SparseNumericDocValues(disi){
                final VaryingBPVReader vBPVReader;
                {
                    super(disi);
                    this.vBPVReader = new VaryingBPVReader(entry, slice);
                }

                @Override
                public long longValue() throws IOException {
                    int index = this.disi.index();
                    return this.vBPVReader.getLongValue(index);
                }
            };
        }
        final LongValues values = LegacyDirectReader.getInstance(slice, entry.bitsPerValue);
        if (entry.table != null) {
            final long[] table = entry.table;
            return new SparseNumericDocValues(disi){

                @Override
                public long longValue() throws IOException {
                    return table[(int)values.get(this.disi.index())];
                }
            };
        }
        final long mul = entry.gcd;
        final long delta = entry.minValue;
        return new SparseNumericDocValues(disi){

            @Override
            public long longValue() throws IOException {
                return mul * values.get(this.disi.index()) + delta;
            }
        };
    }

    private LongValues getNumericValues(final NumericEntry entry) throws IOException {
        if (entry.bitsPerValue == 0) {
            return new LongValues(){

                @Override
                public long get(long index) {
                    return entry.minValue;
                }
            };
        }
        final RandomAccessInput slice = this.data.randomAccessSlice(entry.valuesOffset, entry.valuesLength);
        if (entry.blockShift >= 0) {
            return new LongValues(){
                final VaryingBPVReader vBPVReader;
                {
                    this.vBPVReader = new VaryingBPVReader(entry, slice);
                }

                @Override
                public long get(long index) {
                    try {
                        return this.vBPVReader.getLongValue(index);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        final LongValues values = LegacyDirectReader.getInstance(slice, entry.bitsPerValue);
        if (entry.table != null) {
            final long[] table = entry.table;
            return new LongValues(){

                @Override
                public long get(long index) {
                    return table[(int)values.get(index)];
                }
            };
        }
        if (entry.gcd != 1L) {
            final long gcd = entry.gcd;
            final long minValue = entry.minValue;
            return new LongValues(){

                @Override
                public long get(long index) {
                    return values.get(index) * gcd + minValue;
                }
            };
        }
        if (entry.minValue != 0L) {
            final long minValue = entry.minValue;
            return new LongValues(){

                @Override
                public long get(long index) {
                    return values.get(index) + minValue;
                }
            };
        }
        return values;
    }

    private BinaryDocValues getUncompressedBinary(final BinaryEntry entry) throws IOException {
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyBinary();
        }
        final IndexInput bytesSlice = this.data.slice("fixed-binary", entry.dataOffset, entry.dataLength);
        if (entry.docsWithFieldOffset == -1L) {
            if (entry.minLength == entry.maxLength) {
                final int length = entry.maxLength;
                return new DenseBinaryDocValues(this.maxDoc){
                    final BytesRef bytes;
                    {
                        super(maxDoc);
                        this.bytes = new BytesRef(new byte[length], 0, length);
                    }

                    @Override
                    public BytesRef binaryValue() throws IOException {
                        bytesSlice.seek((long)this.doc * (long)length);
                        bytesSlice.readBytes(this.bytes.bytes, 0, length);
                        return this.bytes;
                    }
                };
            }
            RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
            final LegacyDirectMonotonicReader addresses = LegacyDirectMonotonicReader.getInstance(entry.addressesMeta, addressesData);
            return new DenseBinaryDocValues(this.maxDoc){
                final BytesRef bytes;
                {
                    super(maxDoc);
                    this.bytes = new BytesRef(new byte[entry.maxLength], 0, entry.maxLength);
                }

                @Override
                public BytesRef binaryValue() throws IOException {
                    long startOffset = addresses.get(this.doc);
                    this.bytes.length = (int)(addresses.get((long)this.doc + 1L) - startOffset);
                    bytesSlice.seek(startOffset);
                    bytesSlice.readBytes(this.bytes.bytes, 0, this.bytes.length);
                    return this.bytes;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numDocsWithField);
        if (entry.minLength == entry.maxLength) {
            final int length = entry.maxLength;
            return new SparseBinaryDocValues(disi){
                final BytesRef bytes;
                {
                    super(disi);
                    this.bytes = new BytesRef(new byte[length], 0, length);
                }

                @Override
                public BytesRef binaryValue() throws IOException {
                    bytesSlice.seek((long)this.disi.index() * (long)length);
                    bytesSlice.readBytes(this.bytes.bytes, 0, length);
                    return this.bytes;
                }
            };
        }
        RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        final LegacyDirectMonotonicReader addresses = LegacyDirectMonotonicReader.getInstance(entry.addressesMeta, addressesData);
        return new SparseBinaryDocValues(disi){
            final BytesRef bytes;
            {
                super(disi);
                this.bytes = new BytesRef(new byte[entry.maxLength], 0, entry.maxLength);
            }

            @Override
            public BytesRef binaryValue() throws IOException {
                int index = this.disi.index();
                long startOffset = addresses.get(index);
                this.bytes.length = (int)(addresses.get((long)index + 1L) - startOffset);
                bytesSlice.seek(startOffset);
                bytesSlice.readBytes(this.bytes.bytes, 0, this.bytes.length);
                return this.bytes;
            }
        };
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryEntry entry = this.binaries.get(field.name);
        if (entry.compressed) {
            return this.getCompressedBinary(entry);
        }
        return this.getUncompressedBinary(entry);
    }

    private BinaryDocValues getCompressedBinary(final BinaryEntry entry) throws IOException {
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptyBinary();
        }
        if (entry.docsWithFieldOffset == -1L) {
            RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
            final LegacyDirectMonotonicReader addresses = LegacyDirectMonotonicReader.getInstance(entry.addressesMeta, addressesData);
            return new DenseBinaryDocValues(this.maxDoc){
                BinaryDecoder decoder;
                {
                    super(maxDoc);
                    this.decoder = new BinaryDecoder(addresses, Lucene80DocValuesProducer.this.data.clone(), entry.maxUncompressedChunkSize, entry.docsPerChunkShift);
                }

                @Override
                public BytesRef binaryValue() throws IOException {
                    return this.decoder.decode(this.doc);
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numDocsWithField);
        RandomAccessInput addressesData = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        final LegacyDirectMonotonicReader addresses = LegacyDirectMonotonicReader.getInstance(entry.addressesMeta, addressesData);
        return new SparseBinaryDocValues(disi){
            BinaryDecoder decoder;
            {
                super(disi);
                this.decoder = new BinaryDecoder(addresses, Lucene80DocValuesProducer.this.data.clone(), entry.maxUncompressedChunkSize, entry.docsPerChunkShift);
            }

            @Override
            public BytesRef binaryValue() throws IOException {
                return this.decoder.decode(this.disi.index());
            }
        };
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        SortedEntry entry = this.sorted.get(field.name);
        return this.getSorted(entry);
    }

    private SortedDocValues getSorted(SortedEntry entry) throws IOException {
        LongValues ords;
        if (entry.docsWithFieldOffset == -2L) {
            return DocValues.emptySorted();
        }
        if (entry.bitsPerValue == 0) {
            ords = new LongValues(){

                @Override
                public long get(long index) {
                    return 0L;
                }
            };
        } else {
            RandomAccessInput slice = this.data.randomAccessSlice(entry.ordsOffset, entry.ordsLength);
            ords = LegacyDirectReader.getInstance(slice, entry.bitsPerValue);
        }
        if (entry.docsWithFieldOffset == -1L) {
            return new BaseSortedDocValues(entry, this.data){
                int doc;
                {
                    super(entry, data);
                    this.doc = -1;
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public long cost() {
                    return Lucene80DocValuesProducer.this.maxDoc;
                }

                @Override
                public int advance(int target) throws IOException {
                    if (target >= Lucene80DocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.doc = target;
                    return this.doc;
                }

                @Override
                public boolean advanceExact(int target) {
                    this.doc = target;
                    return true;
                }

                @Override
                public int ordValue() {
                    return (int)ords.get(this.doc);
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numDocsWithField);
        return new BaseSortedDocValues(entry, this.data){

            @Override
            public int nextDoc() throws IOException {
                return disi.nextDoc();
            }

            @Override
            public int docID() {
                return disi.docID();
            }

            @Override
            public long cost() {
                return disi.cost();
            }

            @Override
            public int advance(int target) throws IOException {
                return disi.advance(target);
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return disi.advanceExact(target);
            }

            @Override
            public int ordValue() {
                return (int)ords.get(disi.index());
            }
        };
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedNumericEntry entry = this.sortedNumerics.get(field.name);
        if (entry.numValues == (long)entry.numDocsWithField) {
            return DocValues.singleton(this.getNumeric(entry));
        }
        RandomAccessInput addressesInput = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        final LegacyDirectMonotonicReader addresses = LegacyDirectMonotonicReader.getInstance(entry.addressesMeta, addressesInput);
        final LongValues values = this.getNumericValues(entry);
        if (entry.docsWithFieldOffset == -1L) {
            return new SortedNumericDocValues(){
                int doc = -1;
                long start;
                long end;
                int count;

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public long cost() {
                    return Lucene80DocValuesProducer.this.maxDoc;
                }

                @Override
                public int advance(int target) throws IOException {
                    if (target >= Lucene80DocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return this.doc;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return true;
                }

                @Override
                public long nextValue() throws IOException {
                    return values.get(this.start++);
                }

                @Override
                public int docValueCount() {
                    return this.count;
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numDocsWithField);
        return new SortedNumericDocValues(){
            boolean set;
            long start;
            long end;
            int count;

            @Override
            public int nextDoc() throws IOException {
                this.set = false;
                return disi.nextDoc();
            }

            @Override
            public int docID() {
                return disi.docID();
            }

            @Override
            public long cost() {
                return disi.cost();
            }

            @Override
            public int advance(int target) throws IOException {
                this.set = false;
                return disi.advance(target);
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return disi.advanceExact(target);
            }

            @Override
            public long nextValue() throws IOException {
                this.set();
                return values.get(this.start++);
            }

            @Override
            public int docValueCount() {
                this.set();
                return this.count;
            }

            private void set() {
                if (!this.set) {
                    int index = disi.index();
                    this.start = addresses.get(index);
                    this.end = addresses.get((long)index + 1L);
                    this.count = (int)(this.end - this.start);
                    this.set = true;
                }
            }
        };
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetEntry entry = this.sortedSets.get(field.name);
        if (entry.singleValueEntry != null) {
            return DocValues.singleton(this.getSorted(entry.singleValueEntry));
        }
        RandomAccessInput slice = this.data.randomAccessSlice(entry.ordsOffset, entry.ordsLength);
        final LongValues ords = LegacyDirectReader.getInstance(slice, entry.bitsPerValue);
        RandomAccessInput addressesInput = this.data.randomAccessSlice(entry.addressesOffset, entry.addressesLength);
        final LegacyDirectMonotonicReader addresses = LegacyDirectMonotonicReader.getInstance(entry.addressesMeta, addressesInput);
        if (entry.docsWithFieldOffset == -1L) {
            return new BaseSortedSetDocValues(entry, this.data){
                int doc;
                long start;
                long end;
                int count;
                {
                    super(entry, data);
                    this.doc = -1;
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                @Override
                public int docID() {
                    return this.doc;
                }

                @Override
                public long cost() {
                    return Lucene80DocValuesProducer.this.maxDoc;
                }

                @Override
                public int advance(int target) throws IOException {
                    if (target >= Lucene80DocValuesProducer.this.maxDoc) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return this.doc;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    this.start = addresses.get(target);
                    this.end = addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return true;
                }

                @Override
                public long nextOrd() throws IOException {
                    if (this.start == this.end) {
                        return -1L;
                    }
                    return ords.get(this.start++);
                }

                @Override
                public int docValueCount() {
                    return this.count;
                }
            };
        }
        final IndexedDISI disi = new IndexedDISI(this.data, entry.docsWithFieldOffset, entry.docsWithFieldLength, entry.jumpTableEntryCount, entry.denseRankPower, entry.numDocsWithField);
        return new BaseSortedSetDocValues(entry, this.data){
            boolean set;
            long start;
            long end;
            int count;
            {
                super(entry, data);
                this.end = 0L;
            }

            @Override
            public int nextDoc() throws IOException {
                this.set = false;
                return disi.nextDoc();
            }

            @Override
            public int docID() {
                return disi.docID();
            }

            @Override
            public long cost() {
                return disi.cost();
            }

            @Override
            public int advance(int target) throws IOException {
                this.set = false;
                return disi.advance(target);
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return disi.advanceExact(target);
            }

            private boolean set() {
                if (!this.set) {
                    int index = disi.index();
                    this.start = addresses.get(index);
                    this.end = addresses.get((long)index + 1L);
                    this.count = (int)(this.end - this.start);
                    this.set = true;
                    return true;
                }
                return false;
            }

            @Override
            public long nextOrd() throws IOException {
                if (this.set()) {
                    return ords.get(this.start++);
                }
                if (this.start == this.end) {
                    return -1L;
                }
                return ords.get(this.start++);
            }

            @Override
            public int docValueCount() {
                this.set();
                return this.count;
            }
        };
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    private class VaryingBPVReader {
        final RandomAccessInput slice;
        final RandomAccessInput rankSlice;
        final NumericEntry entry;
        final int shift;
        final long mul;
        final int mask;
        long block = -1L;
        long delta;
        long offset;
        long blockEndOffset;
        LongValues values;

        VaryingBPVReader(NumericEntry entry, RandomAccessInput slice) throws IOException {
            this.entry = entry;
            this.slice = slice;
            this.rankSlice = entry.valueJumpTableOffset == -1L ? null : Lucene80DocValuesProducer.this.data.randomAccessSlice(entry.valueJumpTableOffset, Lucene80DocValuesProducer.this.data.length() - entry.valueJumpTableOffset);
            this.shift = entry.blockShift;
            this.mul = entry.gcd;
            this.mask = (1 << this.shift) - 1;
        }

        long getLongValue(long index) throws IOException {
            long block = index >>> this.shift;
            if (this.block != block) {
                byte bitsPerValue;
                do {
                    if (this.rankSlice != null && block != this.block + 1L) {
                        this.blockEndOffset = this.rankSlice.readLong(block * 8L) - this.entry.valuesOffset;
                        this.block = block - 1L;
                    }
                    this.offset = this.blockEndOffset;
                    bitsPerValue = this.slice.readByte(this.offset++);
                    this.delta = this.slice.readLong(this.offset);
                    this.offset += 8L;
                    if (bitsPerValue == 0) {
                        this.blockEndOffset = this.offset;
                    } else {
                        int length = this.slice.readInt(this.offset);
                        this.offset += 4L;
                        this.blockEndOffset = this.offset + (long)length;
                    }
                    ++this.block;
                } while (this.block != block);
                this.values = bitsPerValue == 0 ? LongValues.ZEROES : LegacyDirectReader.getInstance(this.slice, bitsPerValue, this.offset);
            }
            return this.mul * this.values.get(index & (long)this.mask) + this.delta;
        }
    }

    private static class TermsDict
    extends BaseTermsEnum {
        static final int LZ4_DECOMPRESSOR_PADDING = 7;
        final TermsDictEntry entry;
        final LongValues blockAddresses;
        final IndexInput bytes;
        final long blockMask;
        final LongValues indexAddresses;
        final IndexInput indexBytes;
        final BytesRef term;
        long ord = -1L;
        BytesRef blockBuffer = null;
        ByteArrayDataInput blockInput = null;
        long currentCompressedBlockStart = -1L;
        long currentCompressedBlockEnd = -1L;

        TermsDict(TermsDictEntry entry, IndexInput data) throws IOException {
            this.entry = entry;
            RandomAccessInput addressesSlice = data.randomAccessSlice(entry.termsAddressesOffset, entry.termsAddressesLength);
            this.blockAddresses = LegacyDirectMonotonicReader.getInstance(entry.termsAddressesMeta, addressesSlice);
            this.bytes = data.slice("terms", entry.termsDataOffset, entry.termsDataLength);
            this.blockMask = (1L << entry.termsDictBlockShift) - 1L;
            RandomAccessInput indexAddressesSlice = data.randomAccessSlice(entry.termsIndexAddressesOffset, entry.termsIndexAddressesLength);
            this.indexAddresses = LegacyDirectMonotonicReader.getInstance(entry.termsIndexAddressesMeta, indexAddressesSlice);
            this.indexBytes = data.slice("terms-index", entry.termsIndexOffset, entry.termsIndexLength);
            this.term = new BytesRef(entry.maxTermLength);
            if (entry.compressed) {
                int bufferSize = entry.maxBlockLength + 7;
                this.blockBuffer = new BytesRef(new byte[bufferSize], 0, bufferSize);
            }
        }

        @Override
        public BytesRef next() throws IOException {
            if (++this.ord >= this.entry.termsDictSize) {
                return null;
            }
            if ((this.ord & this.blockMask) == 0L) {
                if (this.entry.compressed) {
                    this.decompressBlock();
                } else {
                    this.term.length = this.bytes.readVInt();
                    this.bytes.readBytes(this.term.bytes, 0, this.term.length);
                }
            } else {
                DataInput input = this.entry.compressed ? this.blockInput : this.bytes;
                int token = Byte.toUnsignedInt(input.readByte());
                int prefixLength = token & 0xF;
                int suffixLength = 1 + (token >>> 4);
                if (prefixLength == 15) {
                    prefixLength += input.readVInt();
                }
                if (suffixLength == 16) {
                    suffixLength += input.readVInt();
                }
                this.term.length = prefixLength + suffixLength;
                input.readBytes(this.term.bytes, prefixLength, suffixLength);
            }
            return this.term;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            if (ord < 0L || ord >= this.entry.termsDictSize) {
                throw new IndexOutOfBoundsException();
            }
            long blockIndex = ord >>> this.entry.termsDictBlockShift;
            long blockAddress = this.blockAddresses.get(blockIndex);
            this.bytes.seek(blockAddress);
            this.ord = (blockIndex << this.entry.termsDictBlockShift) - 1L;
            do {
                this.next();
            } while (this.ord < ord);
        }

        private BytesRef getTermFromIndex(long index) throws IOException {
            assert (index >= 0L && index <= this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift);
            long start = this.indexAddresses.get(index);
            this.term.length = (int)(this.indexAddresses.get(index + 1L) - start);
            this.indexBytes.seek(start);
            this.indexBytes.readBytes(this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekTermsIndex(BytesRef text) throws IOException {
            long lo = 0L;
            long hi = this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift;
            while (lo <= hi) {
                long mid = lo + hi >>> 1;
                this.getTermFromIndex(mid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    lo = mid + 1L;
                    continue;
                }
                hi = mid - 1L;
            }
            assert (hi < 0L || this.getTermFromIndex(hi).compareTo(text) <= 0);
            assert (hi == this.entry.termsDictSize - 1L >>> this.entry.termsDictIndexShift || this.getTermFromIndex(hi + 1L).compareTo(text) > 0);
            return hi;
        }

        private BytesRef getFirstTermFromBlock(long block) throws IOException {
            assert (block >= 0L && block <= this.entry.termsDictSize - 1L >>> this.entry.termsDictBlockShift);
            long blockAddress = this.blockAddresses.get(block);
            this.bytes.seek(blockAddress);
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            return this.term;
        }

        private long seekBlock(BytesRef text) throws IOException {
            long index = this.seekTermsIndex(text);
            if (index == -1L) {
                return -1L;
            }
            long ordLo = index << this.entry.termsDictIndexShift;
            long ordHi = Math.min(this.entry.termsDictSize, ordLo + (1L << this.entry.termsDictIndexShift)) - 1L;
            long blockLo = ordLo >>> this.entry.termsDictBlockShift;
            long blockHi = ordHi >>> this.entry.termsDictBlockShift;
            while (blockLo <= blockHi) {
                long blockMid = blockLo + blockHi >>> 1;
                this.getFirstTermFromBlock(blockMid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    blockLo = blockMid + 1L;
                    continue;
                }
                blockHi = blockMid - 1L;
            }
            assert (blockHi < 0L || this.getFirstTermFromBlock(blockHi).compareTo(text) <= 0);
            assert (blockHi == this.entry.termsDictSize - 1L >>> this.entry.termsDictBlockShift || this.getFirstTermFromBlock(blockHi + 1L).compareTo(text) > 0);
            return blockHi;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            long block = this.seekBlock(text);
            if (block == -1L) {
                this.seekExact(0L);
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            long blockAddress = this.blockAddresses.get(block);
            this.ord = block << this.entry.termsDictBlockShift;
            this.bytes.seek(blockAddress);
            if (this.entry.compressed) {
                this.decompressBlock();
            } else {
                this.term.length = this.bytes.readVInt();
                this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            }
            do {
                int cmp;
                if ((cmp = this.term.compareTo(text)) == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (cmp <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (this.next() != null);
            return TermsEnum.SeekStatus.END;
        }

        private void decompressBlock() throws IOException {
            this.term.length = this.bytes.readVInt();
            this.bytes.readBytes(this.term.bytes, 0, this.term.length);
            long offset = this.bytes.getFilePointer();
            if (offset < this.entry.termsDataLength - 1L) {
                if (this.currentCompressedBlockStart != offset) {
                    int decompressLength = this.bytes.readVInt();
                    LZ4.decompress(EndiannessReverserUtil.wrapDataInput(this.bytes), decompressLength, this.blockBuffer.bytes, 0);
                    this.currentCompressedBlockStart = offset;
                    this.currentCompressedBlockEnd = this.bytes.getFilePointer();
                } else {
                    this.bytes.seek(this.currentCompressedBlockEnd);
                }
                this.blockInput = new ByteArrayDataInput(this.blockBuffer.bytes, 0, this.blockBuffer.length);
            }
        }

        @Override
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            return this.ord;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class BaseSortedSetDocValues
    extends SortedSetDocValues {
        final SortedSetEntry entry;
        final IndexInput data;
        final TermsEnum termsEnum;

        BaseSortedSetDocValues(SortedSetEntry entry, IndexInput data) throws IOException {
            this.entry = entry;
            this.data = data;
            this.termsEnum = this.termsEnum();
        }

        @Override
        public long getValueCount() {
            return this.entry.termsDictSize;
        }

        @Override
        public BytesRef lookupOrd(long ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        @Override
        public long lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            switch (status) {
                case FOUND: {
                    return this.termsEnum.ord();
                }
            }
            return -1L - this.termsEnum.ord();
        }

        @Override
        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry, this.data);
        }
    }

    private static abstract class BaseSortedDocValues
    extends SortedDocValues {
        final SortedEntry entry;
        final IndexInput data;
        final TermsEnum termsEnum;

        BaseSortedDocValues(SortedEntry entry, IndexInput data) throws IOException {
            this.entry = entry;
            this.data = data;
            this.termsEnum = this.termsEnum();
        }

        @Override
        public int getValueCount() {
            return Math.toIntExact(this.entry.termsDictSize);
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            switch (status) {
                case FOUND: {
                    return Math.toIntExact(this.termsEnum.ord());
                }
            }
            return Math.toIntExact(-1L - this.termsEnum.ord());
        }

        @Override
        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry, this.data);
        }
    }

    static class BinaryDecoder {
        private final LongValues addresses;
        private final IndexInput compressedData;
        private long lastBlockId = -1L;
        private final int[] uncompressedDocStarts;
        private int uncompressedBlockLength = 0;
        private final byte[] uncompressedBlock;
        private final BytesRef uncompressedBytesRef;
        private final int docsPerChunk;
        private final int docsPerChunkShift;

        public BinaryDecoder(LongValues addresses, IndexInput compressedData, int biggestUncompressedBlockSize, int docsPerChunkShift) {
            this.addresses = addresses;
            this.compressedData = compressedData;
            this.uncompressedBlock = new byte[biggestUncompressedBlockSize];
            this.uncompressedBytesRef = new BytesRef(this.uncompressedBlock);
            this.docsPerChunk = 1 << docsPerChunkShift;
            this.docsPerChunkShift = docsPerChunkShift;
            this.uncompressedDocStarts = new int[this.docsPerChunk + 1];
        }

        BytesRef decode(int docNumber) throws IOException {
            int blockId = docNumber >> this.docsPerChunkShift;
            int docInBlockId = docNumber % this.docsPerChunk;
            assert (docInBlockId < this.docsPerChunk);
            if ((long)blockId != this.lastBlockId) {
                this.lastBlockId = blockId;
                long blockStartOffset = this.addresses.get(blockId);
                this.compressedData.seek(blockStartOffset);
                this.uncompressedBlockLength = 0;
                int onlyLength = -1;
                for (int i = 0; i < this.docsPerChunk; ++i) {
                    if (i == 0) {
                        int lengthPlusSameInd = this.compressedData.readVInt();
                        int sameIndicator = lengthPlusSameInd & 1;
                        int firstValLength = lengthPlusSameInd >>> 1;
                        if (sameIndicator == 1) {
                            onlyLength = firstValLength;
                        }
                        this.uncompressedBlockLength += firstValLength;
                    } else {
                        this.uncompressedBlockLength = onlyLength == -1 ? (this.uncompressedBlockLength += this.compressedData.readVInt()) : (this.uncompressedBlockLength += onlyLength);
                    }
                    this.uncompressedDocStarts[i + 1] = this.uncompressedBlockLength;
                }
                if (this.uncompressedBlockLength == 0) {
                    this.uncompressedBytesRef.offset = 0;
                    this.uncompressedBytesRef.length = 0;
                    return this.uncompressedBytesRef;
                }
                assert (this.uncompressedBlockLength <= this.uncompressedBlock.length);
                LZ4.decompress(EndiannessReverserUtil.wrapDataInput(this.compressedData), this.uncompressedBlockLength, this.uncompressedBlock, 0);
            }
            this.uncompressedBytesRef.offset = this.uncompressedDocStarts[docInBlockId];
            this.uncompressedBytesRef.length = this.uncompressedDocStarts[docInBlockId + 1] - this.uncompressedBytesRef.offset;
            return this.uncompressedBytesRef;
        }
    }

    private static abstract class SparseBinaryDocValues
    extends BinaryDocValues {
        final IndexedDISI disi;

        SparseBinaryDocValues(IndexedDISI disi) {
            this.disi = disi;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }
    }

    private static abstract class DenseBinaryDocValues
    extends BinaryDocValues {
        final int maxDoc;
        int doc = -1;

        DenseBinaryDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.doc = target;
            return true;
        }
    }

    private static abstract class SparseNumericDocValues
    extends NumericDocValues {
        final IndexedDISI disi;

        SparseNumericDocValues(IndexedDISI disi) {
            this.disi = disi;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }
    }

    private static abstract class DenseNumericDocValues
    extends NumericDocValues {
        final int maxDoc;
        int doc = -1;

        DenseNumericDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            if (target >= this.maxDoc) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public boolean advanceExact(int target) {
            this.doc = target;
            return true;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }
    }

    private static class SortedNumericEntry
    extends NumericEntry {
        int numDocsWithField;
        LegacyDirectMonotonicReader.Meta addressesMeta;
        long addressesOffset;
        long addressesLength;

        private SortedNumericEntry() {
        }
    }

    private static class SortedSetEntry
    extends TermsDictEntry {
        SortedEntry singleValueEntry;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        byte denseRankPower;
        int numDocsWithField;
        byte bitsPerValue;
        long ordsOffset;
        long ordsLength;
        LegacyDirectMonotonicReader.Meta addressesMeta;
        long addressesOffset;
        long addressesLength;

        private SortedSetEntry() {
        }
    }

    private static class SortedEntry
    extends TermsDictEntry {
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        byte denseRankPower;
        int numDocsWithField;
        byte bitsPerValue;
        long ordsOffset;
        long ordsLength;

        private SortedEntry() {
        }
    }

    private static class TermsDictEntry {
        long termsDictSize;
        int termsDictBlockShift;
        LegacyDirectMonotonicReader.Meta termsAddressesMeta;
        int maxTermLength;
        long termsDataOffset;
        long termsDataLength;
        long termsAddressesOffset;
        long termsAddressesLength;
        int termsDictIndexShift;
        LegacyDirectMonotonicReader.Meta termsIndexAddressesMeta;
        long termsIndexOffset;
        long termsIndexLength;
        long termsIndexAddressesOffset;
        long termsIndexAddressesLength;
        boolean compressed;
        int maxBlockLength;

        private TermsDictEntry() {
        }
    }

    private static class BinaryEntry {
        boolean compressed;
        long dataOffset;
        long dataLength;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        byte denseRankPower;
        int numDocsWithField;
        int minLength;
        int maxLength;
        long addressesOffset;
        long addressesLength;
        LegacyDirectMonotonicReader.Meta addressesMeta;
        int numCompressedChunks;
        int docsPerChunkShift;
        int maxUncompressedChunkSize;

        private BinaryEntry() {
        }
    }

    private static class NumericEntry {
        long[] table;
        int blockShift;
        byte bitsPerValue;
        long docsWithFieldOffset;
        long docsWithFieldLength;
        short jumpTableEntryCount;
        byte denseRankPower;
        long numValues;
        long minValue;
        long gcd;
        long valuesOffset;
        long valuesLength;
        long valueJumpTableOffset;

        private NumericEntry() {
        }
    }
}

