/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.misc;

import java.nio.file.Paths;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexWriterConfig;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.misc.store.HardlinkCopyDirectoryWrapper;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FSDirectory;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.SuppressForbidden;

@SuppressForbidden(reason="System.out required: command line tool")
public class IndexMergeTool {
    static final String USAGE = "Usage: IndexMergeTool [OPTION...] <mergedIndex> <index1> <index2> [index3] ...\nMerges source indexes 'index1' .. 'indexN' into 'mergedIndex'\n\nOPTIONS:\n -merge-policy ClassName  specifies MergePolicy class (must be in CLASSPATH).The default is\n                          'org.apache.lucene.index.TieredMergePolicy.TieredMergePolicy'\n -max-segments N          force-merge's the index to a maximum of N segments. Default is\n                          to execute only the merges according to the merge policy.\n -verbose                 print additional details.\n";

    public static void main(String[] args) throws Exception {
        Options options = null;
        try {
            options = Options.parse(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        HardlinkCopyDirectoryWrapper mergedIndex = new HardlinkCopyDirectoryWrapper(FSDirectory.open(Paths.get(options.mergedIndexPath, new String[0])));
        Directory[] indexes = new Directory[options.indexPaths.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = FSDirectory.open(Paths.get(options.indexPaths[i], new String[0]));
        }
        IndexWriter writer = new IndexWriter(mergedIndex, options.config);
        System.out.println("Merging...");
        writer.addIndexes(indexes);
        if (options.maxSegments > 0) {
            System.out.println("Force-merging to " + options.maxSegments + "...");
            writer.forceMerge(options.maxSegments);
        }
        writer.close();
        System.out.println("Done.");
    }

    @SuppressForbidden(reason="System.err required (verbose mode): command line tool")
    static class Options {
        String mergedIndexPath;
        String[] indexPaths;
        IndexWriterConfig config = new IndexWriterConfig(null).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        int maxSegments = 0;

        Options() {
        }

        static Options parse(String[] args) throws ReflectiveOperationException {
            int index;
            Options options = new Options();
            block10: for (index = 0; index < args.length && args[index].startsWith("-") && args[index] != "--"; ++index) {
                switch (args[index]) {
                    case "-merge-policy": {
                        String clazzName = args[++index];
                        Class<MergePolicy> clazz = Class.forName(clazzName).asSubclass(MergePolicy.class);
                        options.config.setMergePolicy(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        continue block10;
                    }
                    case "-max-segments": {
                        options.maxSegments = Integer.parseInt(args[++index]);
                        continue block10;
                    }
                    case "-verbose": {
                        options.config.setInfoStream(System.err);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("unrecognized option: '" + args[index] + "'\nUsage: IndexMergeTool [OPTION...] <mergedIndex> <index1> <index2> [index3] ...\nMerges source indexes 'index1' .. 'indexN' into 'mergedIndex'\n\nOPTIONS:\n -merge-policy ClassName  specifies MergePolicy class (must be in CLASSPATH).The default is\n                          'org.apache.lucene.index.TieredMergePolicy.TieredMergePolicy'\n -max-segments N          force-merge's the index to a maximum of N segments. Default is\n                          to execute only the merges according to the merge policy.\n -verbose                 print additional details.\n");
                    }
                }
            }
            int numPaths = args.length - index;
            if (numPaths < 3) {
                throw new IllegalArgumentException("not enough parameters.\nUsage: IndexMergeTool [OPTION...] <mergedIndex> <index1> <index2> [index3] ...\nMerges source indexes 'index1' .. 'indexN' into 'mergedIndex'\n\nOPTIONS:\n -merge-policy ClassName  specifies MergePolicy class (must be in CLASSPATH).The default is\n                          'org.apache.lucene.index.TieredMergePolicy.TieredMergePolicy'\n -max-segments N          force-merge's the index to a maximum of N segments. Default is\n                          to execute only the merges according to the merge policy.\n -verbose                 print additional details.\n");
            }
            options.mergedIndexPath = args[index];
            options.indexPaths = new String[numPaths - 1];
            System.arraycopy(args, index + 1, options.indexPaths, 0, options.indexPaths.length);
            return options;
        }
    }
}

