/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.misc.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.CodecReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FilterCodecReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexWriterConfig;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NoMergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentCommitInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.NamedThreadFactory;

public class IndexRearranger {
    protected final Directory input;
    protected final Directory output;
    protected final IndexWriterConfig config;
    protected final List<DocumentSelector> documentSelectors;

    public IndexRearranger(Directory input, Directory output, IndexWriterConfig config, List<DocumentSelector> documentSelectors) {
        this.input = input;
        this.output = output;
        this.config = config;
        this.documentSelectors = documentSelectors;
    }

    public void execute() throws Exception {
        DirectoryReader reader;
        this.config.setMergePolicy(NoMergePolicy.INSTANCE);
        try (IndexWriter writer = new IndexWriter(this.output, this.config);){
            reader = DirectoryReader.open(this.input);
            try {
                ExecutorService executor = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), this.documentSelectors.size()), new NamedThreadFactory("rearranger"));
                ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
                for (DocumentSelector documentSelector : this.documentSelectors) {
                    Callable<Void> addSegment = () -> {
                        IndexRearranger.addOneSegment(writer, reader, record);
                        return null;
                    };
                    futures.add(executor.submit(addSegment));
                }
                for (Future future : futures) {
                    future.get();
                }
                executor.shutdown();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        ArrayList<SegmentCommitInfo> ordered = new ArrayList<SegmentCommitInfo>();
        reader = DirectoryReader.open(this.output);
        try {
            for (DocumentSelector ds : this.documentSelectors) {
                int foundLeaf = -1;
                for (LeafReaderContext context : reader.leaves()) {
                    SegmentReader sr = (SegmentReader)context.reader();
                    int docFound = ds.getFilteredLiveDocs(sr).nextSetBit(0);
                    if (docFound == Integer.MAX_VALUE) continue;
                    if (foundLeaf != -1) {
                        throw new IllegalStateException("Document selector " + ds + " has matched more than 1 segments. Matched segments order: " + foundLeaf + ", " + context.ord);
                    }
                    foundLeaf = context.ord;
                    ordered.add(sr.getSegmentInfo());
                }
                assert (foundLeaf != -1);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        SegmentInfos sis = SegmentInfos.readLatestCommit(this.output);
        sis.clear();
        sis.addAll(ordered);
        sis.commit(this.output);
    }

    private static void addOneSegment(IndexWriter writer, IndexReader reader, DocumentSelector selector) throws IOException {
        CodecReader[] readers = new CodecReader[reader.leaves().size()];
        for (LeafReaderContext context : reader.leaves()) {
            readers[context.ord] = new DocSelectorFilteredCodecReader((CodecReader)context.reader(), selector);
        }
        writer.addIndexes(readers);
    }

    public static interface DocumentSelector {
        public BitSet getFilteredLiveDocs(CodecReader var1) throws IOException;
    }

    private static class DocSelectorFilteredCodecReader
    extends FilterCodecReader {
        BitSet filteredLiveDocs;
        int numDocs;

        public DocSelectorFilteredCodecReader(CodecReader in, DocumentSelector selector) throws IOException {
            super(in);
            this.filteredLiveDocs = selector.getFilteredLiveDocs(in);
            this.numDocs = this.filteredLiveDocs.cardinality();
        }

        @Override
        public int numDocs() {
            return this.numDocs;
        }

        @Override
        public Bits getLiveDocs() {
            return this.filteredLiveDocs;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }
}

