/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DoubleValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DoubleValuesSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Explanation;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FieldComparatorSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LongValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LongValuesSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Pruning;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorable;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SimpleFieldComparator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SortField;

public abstract class ValueSource {
    public abstract FunctionValues getValues(Map<Object, Object> var1, LeafReaderContext var2) throws IOException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String description();

    public String toString() {
        return this.description();
    }

    public void createWeight(Map<Object, Object> context, IndexSearcher searcher) throws IOException {
    }

    public static Map<Object, Object> newContext(IndexSearcher searcher) {
        IdentityHashMap<Object, Object> context = new IdentityHashMap<Object, Object>();
        context.put("searcher", searcher);
        return context;
    }

    public LongValuesSource asLongValuesSource() {
        return new WrappedLongValuesSource(this, null);
    }

    public DoubleValuesSource asDoubleValuesSource() {
        return new WrappedDoubleValuesSource(this, null);
    }

    public static ValueSource fromDoubleValuesSource(DoubleValuesSource in) {
        return new FromDoubleValuesSource(in);
    }

    public SortField getSortField(boolean reverse) {
        return new ValueSourceSortField(reverse);
    }

    class ValueSourceComparator
    extends SimpleFieldComparator<Double> {
        private final double[] values;
        private FunctionValues docVals;
        private double bottom;
        private final Map<Object, Object> fcontext;
        private double topValue;

        ValueSourceComparator(Map<Object, Object> fcontext, int numHits) {
            this.fcontext = fcontext;
            this.values = new double[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Double.compare(this.values[slot1], this.values[slot2]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Double.compare(this.bottom, this.docVals.doubleVal(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.values[slot] = this.docVals.doubleVal(doc);
        }

        @Override
        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.docVals = ValueSource.this.getValues(this.fcontext, context);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(Double value) {
            this.topValue = value;
        }

        @Override
        public Double value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareTop(int doc) throws IOException {
            double docValue = this.docVals.doubleVal(doc);
            return Double.compare(this.topValue, docValue);
        }
    }

    class ValueSourceComparatorSource
    extends FieldComparatorSource {
        private final Map<Object, Object> context;

        public ValueSourceComparatorSource(Map<Object, Object> context) {
            this.context = context;
        }

        public FieldComparator<Double> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
            return new ValueSourceComparator(this.context, numHits);
        }
    }

    class ValueSourceSortField
    extends SortField {
        public ValueSourceSortField(boolean reverse) {
            super(ValueSource.this.description(), SortField.Type.REWRITEABLE, reverse);
        }

        @Override
        public SortField rewrite(IndexSearcher searcher) throws IOException {
            Map<Object, Object> context = ValueSource.newContext(searcher);
            ValueSource.this.createWeight(context, searcher);
            return new SortField(this.getField(), new ValueSourceComparatorSource(context), this.getReverse());
        }
    }

    private static class FromDoubleValuesSource
    extends ValueSource {
        final DoubleValuesSource in;

        private FromDoubleValuesSource(DoubleValuesSource in) {
            this.in = in;
        }

        @Override
        public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
            Scorable scorer = (Scorable)context.get("scorer");
            DoubleValues scores = scorer == null ? null : DoubleValuesSource.fromScorer(scorer);
            IndexSearcher searcher = (IndexSearcher)context.get("searcher");
            final DoubleValues inner = searcher != null ? this.in.rewrite(searcher).getValues(readerContext, scores) : this.in.getValues(readerContext, scores);
            return new FunctionValues(){

                @Override
                public String toString(int doc) throws IOException {
                    return in.toString();
                }

                @Override
                public float floatVal(int doc) throws IOException {
                    if (!inner.advanceExact(doc)) {
                        return 0.0f;
                    }
                    return (float)inner.doubleValue();
                }

                @Override
                public double doubleVal(int doc) throws IOException {
                    if (!inner.advanceExact(doc)) {
                        return 0.0;
                    }
                    return inner.doubleValue();
                }

                @Override
                public boolean exists(int doc) throws IOException {
                    return inner.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FromDoubleValuesSource that = (FromDoubleValuesSource)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public String description() {
            return this.in.toString();
        }
    }

    static class WrappedDoubleValuesSource
    extends DoubleValuesSource {
        final ValueSource in;
        final IndexSearcher searcher;

        private WrappedDoubleValuesSource(ValueSource in, IndexSearcher searcher) {
            this.in = in;
            this.searcher = searcher;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            Map<Object, Object> context = ValueSource.newContext(this.searcher);
            final ScorableView scorer = new ScorableView(scores);
            context.put("scorer", scorer);
            final FunctionValues fv = this.in.getValues(context, ctx);
            return new DoubleValues(){

                @Override
                public double doubleValue() throws IOException {
                    return fv.doubleVal(scorer.docId);
                }

                @Override
                public boolean advanceExact(int doc) {
                    scorer.docId = doc;
                    return true;
                }
            };
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            Map<Object, Object> context = ValueSource.newContext(this.searcher);
            context.put("scorer", new ScorableView(docId, scoreExplanation.getValue().floatValue()));
            FunctionValues fv = this.in.getValues(context, ctx);
            return fv.explain(docId);
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return new WrappedDoubleValuesSource(this.in, searcher);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedDoubleValuesSource that = (WrappedDoubleValuesSource)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public String toString() {
            return this.in.toString();
        }
    }

    private static class WrappedLongValuesSource
    extends LongValuesSource {
        private final ValueSource in;
        private final IndexSearcher searcher;

        private WrappedLongValuesSource(ValueSource in, IndexSearcher searcher) {
            this.in = in;
            this.searcher = searcher;
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            Map<Object, Object> context = ValueSource.newContext(this.searcher);
            final ScorableView scorer = new ScorableView(scores);
            context.put("scorer", scorer);
            final FunctionValues fv = this.in.getValues(context, ctx);
            return new LongValues(){

                @Override
                public long longValue() throws IOException {
                    return fv.longVal(scorer.docId);
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    scorer.docId = doc;
                    return fv.exists(doc);
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedLongValuesSource that = (WrappedLongValuesSource)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public String toString() {
            return this.in.toString();
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return new WrappedLongValuesSource(this.in, searcher);
        }
    }

    private static class ScorableView
    extends Scorable {
        final DoubleValues scores;
        int docId = -1;
        int scoresDocId = -1;
        float score = 0.0f;

        public ScorableView(int docId, float score) {
            this(null);
            this.docId = this.scoresDocId = docId;
            this.score = score;
        }

        public ScorableView(DoubleValues scores) {
            this.scores = scores == null ? DoubleValues.EMPTY : scores;
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public float score() throws IOException {
            if (this.scoresDocId != this.docId) {
                this.scoresDocId = this.docId;
                this.score = this.scores.advanceExact(this.docId) ? (float)this.scores.doubleValue() : 0.0f;
            }
            return this.score;
        }
    }
}

