/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Collector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.CollectorManager;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MultiCollector;

public class MultiCollectorManager
implements CollectorManager<Collector, Object[]> {
    private final CollectorManager<Collector, ?>[] collectorManagers;

    @SafeVarargs
    public MultiCollectorManager(CollectorManager<? extends Collector, ?> ... collectorManagers) {
        if (collectorManagers.length < 1) {
            throw new IllegalArgumentException("There must be at least one collector manager");
        }
        for (CollectorManager<Collector, ?> collectorManager : collectorManagers) {
            if (collectorManager != null) continue;
            throw new IllegalArgumentException("Collector managers should all be non-null");
        }
        this.collectorManagers = collectorManagers;
    }

    @Override
    public Collector newCollector() throws IOException {
        Collector[] collectors = new Collector[this.collectorManagers.length];
        for (int i = 0; i < this.collectorManagers.length; ++i) {
            collectors[i] = this.collectorManagers[i].newCollector();
        }
        return MultiCollector.wrap(collectors);
    }

    @Override
    public Object[] reduce(Collection<Collector> reducableCollectors) throws IOException {
        int size = reducableCollectors.size();
        Object[] results = new Object[this.collectorManagers.length];
        for (int i = 0; i < this.collectorManagers.length; ++i) {
            ArrayList<Collector> reducableCollector = new ArrayList<Collector>(size);
            for (Collector collector : reducableCollectors) {
                if (collector instanceof MultiCollector) {
                    reducableCollector.add(((MultiCollector)collector).getCollectors()[i]);
                    continue;
                }
                reducableCollector.add(collector);
            }
            results[i] = this.collectorManagers[i].reduce(reducableCollector);
        }
        return results;
    }
}

