/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import org.graylog.shaded.opensearch2.org.apache.lucene.search.AbstractKnnCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TotalHits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.NeighborQueue;

public final class TopKnnCollector
extends AbstractKnnCollector {
    private final NeighborQueue queue;

    public TopKnnCollector(int k, int visitLimit) {
        super(k, visitLimit);
        this.queue = new NeighborQueue(k, false);
    }

    @Override
    public boolean collect(int docId, float similarity) {
        return this.queue.insertWithOverflow(docId, similarity);
    }

    @Override
    public float minCompetitiveSimilarity() {
        return this.queue.size() >= this.k() ? this.queue.topScore() : Float.NEGATIVE_INFINITY;
    }

    @Override
    public TopDocs topDocs() {
        assert (this.queue.size() <= this.k()) : "Tried to collect more results than the maximum number allowed";
        ScoreDoc[] scoreDocs = new ScoreDoc[this.queue.size()];
        for (int i = 1; i <= scoreDocs.length; ++i) {
            scoreDocs[scoreDocs.length - i] = new ScoreDoc(this.queue.topNode(), this.queue.topScore());
            this.queue.pop();
        }
        TotalHits.Relation relation = this.earlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
        return new TopDocs(new TotalHits(this.visitedCount(), relation), scoreDocs);
    }

    public String toString() {
        return "TopKnnCollector[k=" + this.k() + ", size=" + this.queue.size() + "]";
    }
}

