/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities;

import org.graylog.shaded.opensearch2.org.apache.lucene.search.Explanation;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.BasicStats;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.Normalization;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.SimilarityBase;

public class NormalizationH2
extends Normalization {
    private final float c;

    public NormalizationH2(float c) {
        if (!Float.isFinite(c) || c < 0.0f) {
            throw new IllegalArgumentException("illegal c value: " + c + ", must be a non-negative finite value");
        }
        this.c = c;
    }

    public NormalizationH2() {
        this(1.0f);
    }

    @Override
    public final double tfn(BasicStats stats, double tf, double len) {
        return tf * SimilarityBase.log2(1.0 + (double)this.c * stats.getAvgFieldLength() / len);
    }

    @Override
    public Explanation explain(BasicStats stats, double tf, double len) {
        return Explanation.match((Number)Float.valueOf((float)this.tfn(stats, tf, len)), this.getClass().getSimpleName() + ", computed as tf * log2(1 + c * avgfl / fl) from:", Explanation.match((Number)Float.valueOf((float)tf), "tf, number of occurrences of term in the document", new Explanation[0]), Explanation.match((Number)Float.valueOf(this.c), "c, hyper-parameter", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)stats.getAvgFieldLength()), "avgfl, average length of field across all documents", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)len), "fl, field length of the document", new Explanation[0]));
    }

    @Override
    public String toString() {
        return "2";
    }

    public float getC() {
        return this.c;
    }
}

