/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoDegenerateHorizontalLine;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoDegenerateLatitudeZone;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoDegenerateLongitudeSlice;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoDegeneratePoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoDegenerateVerticalLine;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoLatitudeZone;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoLongitudeSlice;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoNorthLatitudeZone;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoNorthRectangle;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoRectangle;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoSouthLatitudeZone;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoSouthRectangle;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoWideDegenerateHorizontalLine;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoWideLongitudeSlice;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoWideNorthRectangle;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoWideRectangle;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoWideSouthRectangle;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoWorld;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.LatLonBounds;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;

public class GeoBBoxFactory {
    private GeoBBoxFactory() {
    }

    public static GeoBBox makeGeoBBox(PlanetModel planetModel, double topLat, double bottomLat, double leftLon, double rightLon) {
        if (topLat > 1.5707963267948966) {
            topLat = 1.5707963267948966;
        }
        if (bottomLat < -1.5707963267948966) {
            bottomLat = -1.5707963267948966;
        }
        if (leftLon < -Math.PI) {
            leftLon = -Math.PI;
        }
        if (rightLon > Math.PI) {
            rightLon = Math.PI;
        }
        if (GeoBBoxFactory.longitudesEquals(leftLon, -Math.PI) && GeoBBoxFactory.longitudesEquals(rightLon, Math.PI) || GeoBBoxFactory.longitudesEquals(rightLon, -Math.PI) && GeoBBoxFactory.longitudesEquals(leftLon, Math.PI)) {
            if (GeoBBoxFactory.isNorthPole(topLat) && GeoBBoxFactory.isSouthPole(bottomLat)) {
                return new GeoWorld(planetModel);
            }
            if (GeoBBoxFactory.latitudesEquals(topLat, bottomLat)) {
                if (GeoBBoxFactory.isNorthPole(topLat)) {
                    return new GeoDegeneratePoint(planetModel, topLat, 0.0);
                }
                if (GeoBBoxFactory.isSouthPole(bottomLat)) {
                    return new GeoDegeneratePoint(planetModel, bottomLat, 0.0);
                }
                return new GeoDegenerateLatitudeZone(planetModel, topLat);
            }
            if (GeoBBoxFactory.isNorthPole(topLat)) {
                return new GeoNorthLatitudeZone(planetModel, bottomLat);
            }
            if (GeoBBoxFactory.isSouthPole(bottomLat)) {
                return new GeoSouthLatitudeZone(planetModel, topLat);
            }
            return new GeoLatitudeZone(planetModel, topLat, bottomLat);
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (GeoBBoxFactory.isNorthPole(topLat) && GeoBBoxFactory.isSouthPole(bottomLat)) {
            if (GeoBBoxFactory.longitudesEquals(leftLon, rightLon)) {
                return new GeoDegenerateLongitudeSlice(planetModel, leftLon);
            }
            if (extent >= Math.PI) {
                return new GeoWideLongitudeSlice(planetModel, leftLon, rightLon);
            }
            return new GeoLongitudeSlice(planetModel, leftLon, rightLon);
        }
        if (GeoBBoxFactory.longitudesEquals(leftLon, rightLon)) {
            if (GeoBBoxFactory.latitudesEquals(topLat, bottomLat)) {
                return new GeoDegeneratePoint(planetModel, topLat, leftLon);
            }
            return new GeoDegenerateVerticalLine(planetModel, topLat, bottomLat, leftLon);
        }
        if (extent >= 3.1415926535866516) {
            if (GeoBBoxFactory.latitudesEquals(topLat, bottomLat)) {
                if (GeoBBoxFactory.isNorthPole(topLat)) {
                    return new GeoDegeneratePoint(planetModel, topLat, 0.0);
                }
                if (GeoBBoxFactory.isSouthPole(bottomLat)) {
                    return new GeoDegeneratePoint(planetModel, bottomLat, 0.0);
                }
                return new GeoWideDegenerateHorizontalLine(planetModel, topLat, leftLon, rightLon);
            }
            if (GeoBBoxFactory.isNorthPole(topLat)) {
                return new GeoWideNorthRectangle(planetModel, bottomLat, leftLon, rightLon);
            }
            if (GeoBBoxFactory.isSouthPole(bottomLat)) {
                return new GeoWideSouthRectangle(planetModel, topLat, leftLon, rightLon);
            }
            return new GeoWideRectangle(planetModel, topLat, bottomLat, leftLon, rightLon);
        }
        if (GeoBBoxFactory.latitudesEquals(topLat, bottomLat)) {
            if (GeoBBoxFactory.isNorthPole(topLat)) {
                return new GeoDegeneratePoint(planetModel, topLat, 0.0);
            }
            if (GeoBBoxFactory.isSouthPole(bottomLat)) {
                return new GeoDegeneratePoint(planetModel, bottomLat, 0.0);
            }
            return new GeoDegenerateHorizontalLine(planetModel, topLat, leftLon, rightLon);
        }
        if (GeoBBoxFactory.isNorthPole(topLat)) {
            return new GeoNorthRectangle(planetModel, bottomLat, leftLon, rightLon);
        }
        if (GeoBBoxFactory.isSouthPole(bottomLat)) {
            return new GeoSouthRectangle(planetModel, topLat, leftLon, rightLon);
        }
        return new GeoRectangle(planetModel, topLat, bottomLat, leftLon, rightLon);
    }

    private static boolean isNorthPole(double lat) {
        return GeoBBoxFactory.latitudesEquals(lat, 1.5707963267948966);
    }

    private static boolean isSouthPole(double lat) {
        return GeoBBoxFactory.latitudesEquals(lat, -1.5707963267948966);
    }

    private static boolean latitudesEquals(double lat1, double lat2) {
        return Math.abs(lat1 - lat2) < 3.141592653589793E-12 || Math.abs(Math.sin(lat1) - Math.sin(lat2)) < 1.0E-12;
    }

    private static boolean longitudesEquals(double lon1, double lon2) {
        return Math.abs(lon1 - lon2) < 3.141592653589793E-12;
    }

    public static GeoBBox makeGeoBBox(PlanetModel planetModel, LatLonBounds bounds) {
        double topLat = bounds.checkNoTopLatitudeBound() ? 1.5707963267948966 : bounds.getMaxLatitude();
        double bottomLat = bounds.checkNoBottomLatitudeBound() ? -1.5707963267948966 : bounds.getMinLatitude();
        double leftLon = bounds.checkNoLongitudeBound() ? -Math.PI : bounds.getLeftLongitude();
        double rightLon = bounds.checkNoLongitudeBound() ? Math.PI : bounds.getRightLongitude();
        return GeoBBoxFactory.makeGeoBBox(planetModel, topLat, bottomLat, leftLon, rightLon);
    }
}

