/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Bounds;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBaseBBox;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Membership;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.SidedPlane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Vector;

class GeoSouthRectangle
extends GeoBaseBBox {
    protected final double topLat;
    protected final double leftLon;
    protected final double rightLon;
    protected final double cosMiddleLat;
    protected final GeoPoint ULHC;
    protected final GeoPoint URHC;
    protected final SidedPlane topPlane;
    protected final SidedPlane leftPlane;
    protected final SidedPlane rightPlane;
    protected final SidedPlane backingPlane;
    protected final GeoPoint[] topPlanePoints;
    protected final GeoPoint[] leftPlanePoints;
    protected final GeoPoint[] rightPlanePoints;
    protected final GeoPoint centerPoint;
    protected final GeoPoint[] edgePoints;

    public GeoSouthRectangle(PlanetModel planetModel, double topLat, double leftLon, double rightLon) {
        super(planetModel);
        if (topLat > 1.5707963267948966 || topLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Top latitude out of range");
        }
        if (leftLon < -Math.PI || leftLon > Math.PI) {
            throw new IllegalArgumentException("Left longitude out of range");
        }
        if (rightLon < -Math.PI || rightLon > Math.PI) {
            throw new IllegalArgumentException("Right longitude out of range");
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (extent > Math.PI) {
            throw new IllegalArgumentException("Width of rectangle too great");
        }
        this.topLat = topLat;
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        double sinTopLat = Math.sin(topLat);
        double cosTopLat = Math.cos(topLat);
        double sinLeftLon = Math.sin(leftLon);
        double cosLeftLon = Math.cos(leftLon);
        double sinRightLon = Math.sin(rightLon);
        double cosRightLon = Math.cos(rightLon);
        this.ULHC = new GeoPoint(planetModel, sinTopLat, sinLeftLon, cosTopLat, cosLeftLon, topLat, leftLon);
        this.URHC = new GeoPoint(planetModel, sinTopLat, sinRightLon, cosTopLat, cosRightLon, topLat, rightLon);
        double middleLat = (topLat - 1.5707963267948966) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.cosMiddleLat = Math.cos(middleLat);
        while (leftLon > rightLon) {
            rightLon += Math.PI * 2;
        }
        double middleLon = (leftLon + rightLon) * 0.5;
        double sinMiddleLon = Math.sin(middleLon);
        double cosMiddleLon = Math.cos(middleLon);
        this.centerPoint = new GeoPoint(planetModel, sinMiddleLat, sinMiddleLon, this.cosMiddleLat, cosMiddleLon);
        this.topPlane = new SidedPlane((Vector)planetModel.SOUTH_POLE, planetModel, sinTopLat);
        this.leftPlane = new SidedPlane((Vector)this.URHC, cosLeftLon, sinLeftLon);
        this.rightPlane = new SidedPlane((Vector)this.ULHC, cosRightLon, sinRightLon);
        assert (this.topPlane.isWithin(this.centerPoint));
        assert (this.leftPlane.isWithin(this.centerPoint));
        assert (this.rightPlane.isWithin(this.centerPoint));
        this.backingPlane = new SidedPlane((Vector)this.centerPoint, cosMiddleLon, sinMiddleLon, 0.0, 0.0);
        this.topPlanePoints = new GeoPoint[]{this.ULHC, this.URHC};
        this.leftPlanePoints = new GeoPoint[]{this.ULHC, planetModel.SOUTH_POLE};
        this.rightPlanePoints = new GeoPoint[]{this.URHC, planetModel.SOUTH_POLE};
        this.edgePoints = new GeoPoint[]{planetModel.SOUTH_POLE};
    }

    public GeoSouthRectangle(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.topLat);
        SerializableObject.writeDouble(outputStream, this.leftLon);
        SerializableObject.writeDouble(outputStream, this.rightLon);
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.topLat + angle;
        double newBottomLat = -1.5707963267948966;
        double currentLonSpan = this.rightLon - this.leftLon;
        if (currentLonSpan < 0.0) {
            currentLonSpan += Math.PI * 2;
        }
        double newLeftLon = this.leftLon - angle;
        double newRightLon = this.rightLon + angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, newTopLat, -1.5707963267948966, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.backingPlane.isWithin(x, y, z) && this.topPlane.isWithin(x, y, z) && this.leftPlane.isWithin(x, y, z) && this.rightPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        double centerAngle = (this.rightLon - (this.rightLon + this.leftLon) * 0.5) * this.cosMiddleLat;
        double topAngle = this.centerPoint.arcDistance(this.URHC);
        return Math.max(centerAngle, topAngle);
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.topPlane, notablePoints, this.topPlanePoints, bounds, this.leftPlane, this.rightPlane) || p.intersects(this.planetModel, this.leftPlane, notablePoints, this.leftPlanePoints, bounds, this.rightPlane, this.topPlane) || p.intersects(this.planetModel, this.rightPlane, notablePoints, this.rightPlanePoints, bounds, this.leftPlane, this.topPlane);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return geoShape.intersects(this.topPlane, this.topPlanePoints, this.leftPlane, this.rightPlane) || geoShape.intersects(this.leftPlane, this.leftPlanePoints, this.rightPlane, this.topPlane) || geoShape.intersects(this.rightPlane, this.rightPlanePoints, this.leftPlane, this.topPlane);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.addHorizontalPlane(this.planetModel, this.topLat, this.topPlane, this.leftPlane, this.rightPlane).addVerticalPlane(this.planetModel, this.leftLon, this.leftPlane, this.topPlane, this.rightPlane).addVerticalPlane(this.planetModel, this.rightLon, this.rightPlane, this.topPlane, this.leftPlane).addPoint(this.URHC).addPoint(this.ULHC).addPoint(this.planetModel.SOUTH_POLE);
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double topDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.topPlane, x, y, z, this.leftPlane, this.rightPlane);
        double leftDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.leftPlane, x, y, z, this.rightPlane, this.topPlane);
        double rightDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.rightPlane, x, y, z, this.leftPlane, this.topPlane);
        double ULHCDistance = distanceStyle.computeDistance(this.ULHC, x, y, z);
        double URHCDistance = distanceStyle.computeDistance(this.URHC, x, y, z);
        return Math.min(Math.min(topDistance, Math.min(leftDistance, rightDistance)), Math.min(ULHCDistance, URHCDistance));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoSouthRectangle)) {
            return false;
        }
        GeoSouthRectangle other = (GeoSouthRectangle)o;
        return super.equals(other) && other.ULHC.equals(this.ULHC) && other.URHC.equals(this.URHC);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.ULHC.hashCode();
        result = 31 * result + this.URHC.hashCode();
        return result;
    }

    public String toString() {
        return "GeoSouthRectangle: {planetmodel=" + this.planetModel + ", toplat=" + this.topLat + "(" + this.topLat * 180.0 / Math.PI + "), leftlon=" + this.leftLon + "(" + this.leftLon * 180.0 / Math.PI + "), rightlon=" + this.rightLon + "(" + this.rightLon * 180.0 / Math.PI + ")}";
    }
}

