/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util;

import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.VectorUtil;

public interface ScalarQuantizedVectorSimilarity {
    public static ScalarQuantizedVectorSimilarity fromVectorSimilarity(VectorSimilarityFunction sim, float constMultiplier) {
        switch (sim) {
            case EUCLIDEAN: {
                return new Euclidean(constMultiplier);
            }
            case COSINE: 
            case DOT_PRODUCT: {
                return new DotProduct(constMultiplier);
            }
            case MAXIMUM_INNER_PRODUCT: {
                return new MaximumInnerProduct(constMultiplier);
            }
        }
        throw new IllegalArgumentException("Unsupported similarity function: " + sim);
    }

    public float score(byte[] var1, float var2, byte[] var3, float var4);

    public static class MaximumInnerProduct
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;

        public MaximumInnerProduct(float constMultiplier) {
            this.constMultiplier = constMultiplier;
        }

        @Override
        public float score(byte[] queryVector, float queryOffset, byte[] storedVector, float vectorOffset) {
            int dotProduct = VectorUtil.dotProduct(storedVector, queryVector);
            float adjustedDistance = (float)dotProduct * this.constMultiplier + queryOffset + vectorOffset;
            return VectorUtil.scaleMaxInnerProductScore(adjustedDistance);
        }
    }

    public static class DotProduct
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;

        public DotProduct(float constMultiplier) {
            this.constMultiplier = constMultiplier;
        }

        @Override
        public float score(byte[] queryVector, float queryOffset, byte[] storedVector, float vectorOffset) {
            int dotProduct = VectorUtil.dotProduct(storedVector, queryVector);
            float adjustedDistance = (float)dotProduct * this.constMultiplier + queryOffset + vectorOffset;
            return (1.0f + adjustedDistance) / 2.0f;
        }
    }

    public static class Euclidean
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;

        public Euclidean(float constMultiplier) {
            this.constMultiplier = constMultiplier;
        }

        @Override
        public float score(byte[] queryVector, float queryVectorOffset, byte[] storedVector, float vectorOffset) {
            int squareDistance = VectorUtil.squareDistance(storedVector, queryVector);
            float adjustedDistance = (float)squareDistance * this.constMultiplier;
            return 1.0f / (1.0f + adjustedDistance);
        }
    }
}

