/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.KnnCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopKnnCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.SparseFixedBitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.HnswGraph;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.NeighborArray;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.NeighborQueue;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.RandomVectorScorer;

public class HnswGraphSearcher {
    private final NeighborQueue candidates;
    private BitSet visited;

    public HnswGraphSearcher(NeighborQueue candidates, BitSet visited) {
        this.candidates = candidates;
        this.visited = visited;
    }

    public static void search(RandomVectorScorer scorer, KnnCollector knnCollector, HnswGraph graph, Bits acceptOrds) throws IOException {
        HnswGraphSearcher graphSearcher = new HnswGraphSearcher(new NeighborQueue(knnCollector.k(), true), new SparseFixedBitSet(HnswGraphSearcher.getGraphSize(graph)));
        HnswGraphSearcher.search(scorer, knnCollector, graph, graphSearcher, acceptOrds);
    }

    public static KnnCollector search(RandomVectorScorer scorer, int topK, OnHeapHnswGraph graph, Bits acceptOrds, int visitedLimit) throws IOException {
        TopKnnCollector knnCollector = new TopKnnCollector(topK, visitedLimit);
        OnHeapHnswGraphSearcher graphSearcher = new OnHeapHnswGraphSearcher(new NeighborQueue(topK, true), new SparseFixedBitSet(HnswGraphSearcher.getGraphSize(graph)));
        HnswGraphSearcher.search(scorer, knnCollector, (HnswGraph)graph, graphSearcher, acceptOrds);
        return knnCollector;
    }

    private static void search(RandomVectorScorer scorer, KnnCollector knnCollector, HnswGraph graph, HnswGraphSearcher graphSearcher, Bits acceptOrds) throws IOException {
        int initialEp = graph.entryNode();
        if (initialEp == -1) {
            return;
        }
        int[] epAndVisited = graphSearcher.findBestEntryPoint(scorer, graph, knnCollector.visitLimit());
        int numVisited = epAndVisited[1];
        int ep = epAndVisited[0];
        if (ep == -1) {
            knnCollector.incVisitedCount(numVisited);
            return;
        }
        knnCollector.incVisitedCount(numVisited);
        graphSearcher.searchLevel(knnCollector, scorer, 0, new int[]{ep}, graph, acceptOrds);
    }

    public HnswGraphBuilder.GraphBuilderKnnCollector searchLevel(RandomVectorScorer scorer, int topK, int level, int[] eps, HnswGraph graph) throws IOException {
        HnswGraphBuilder.GraphBuilderKnnCollector results = new HnswGraphBuilder.GraphBuilderKnnCollector(topK);
        this.searchLevel(results, scorer, level, eps, graph, null);
        return results;
    }

    private int[] findBestEntryPoint(RandomVectorScorer scorer, HnswGraph graph, long visitLimit) throws IOException {
        int size = HnswGraphSearcher.getGraphSize(graph);
        int visitedCount = 1;
        this.prepareScratchState(size);
        int currentEp = graph.entryNode();
        float currentScore = scorer.score(currentEp);
        for (int level = graph.numLevels() - 1; level >= 1; --level) {
            boolean foundBetter = true;
            this.visited.set(currentEp);
            while (foundBetter) {
                int friendOrd;
                foundBetter = false;
                this.graphSeek(graph, level, currentEp);
                while ((friendOrd = this.graphNextNeighbor(graph)) != Integer.MAX_VALUE) {
                    assert (friendOrd < size) : "friendOrd=" + friendOrd + "; size=" + size;
                    if (this.visited.getAndSet(friendOrd)) continue;
                    if ((long)visitedCount >= visitLimit) {
                        return new int[]{-1, visitedCount};
                    }
                    float friendSimilarity = scorer.score(friendOrd);
                    ++visitedCount;
                    if (!(friendSimilarity > currentScore)) continue;
                    currentScore = friendSimilarity;
                    currentEp = friendOrd;
                    foundBetter = true;
                }
            }
        }
        return new int[]{currentEp, visitedCount};
    }

    void searchLevel(KnnCollector results, RandomVectorScorer scorer, int level, int[] eps, HnswGraph graph, Bits acceptOrds) throws IOException {
        float topCandidateSimilarity;
        int size = HnswGraphSearcher.getGraphSize(graph);
        this.prepareScratchState(size);
        for (int ep : eps) {
            if (this.visited.getAndSet(ep)) continue;
            if (results.earlyTerminated()) break;
            float score = scorer.score(ep);
            results.incVisitedCount(1);
            this.candidates.add(ep, score);
            if (acceptOrds != null && !acceptOrds.get(ep)) continue;
            results.collect(ep, score);
        }
        float minAcceptedSimilarity = results.minCompetitiveSimilarity();
        block1: while (this.candidates.size() > 0 && !results.earlyTerminated() && !((topCandidateSimilarity = this.candidates.topScore()) < minAcceptedSimilarity)) {
            int friendOrd;
            int topCandidateNode = this.candidates.pop();
            this.graphSeek(graph, level, topCandidateNode);
            while ((friendOrd = this.graphNextNeighbor(graph)) != Integer.MAX_VALUE) {
                assert (friendOrd < size) : "friendOrd=" + friendOrd + "; size=" + size;
                if (this.visited.getAndSet(friendOrd)) continue;
                if (results.earlyTerminated()) continue block1;
                float friendSimilarity = scorer.score(friendOrd);
                results.incVisitedCount(1);
                if (!(friendSimilarity > minAcceptedSimilarity)) continue;
                this.candidates.add(friendOrd, friendSimilarity);
                if (acceptOrds != null && !acceptOrds.get(friendOrd) || !results.collect(friendOrd, friendSimilarity)) continue;
                minAcceptedSimilarity = results.minCompetitiveSimilarity();
            }
        }
    }

    private void prepareScratchState(int capacity) {
        this.candidates.clear();
        if (this.visited.length() < capacity) {
            this.visited = FixedBitSet.ensureCapacity((FixedBitSet)this.visited, capacity);
        }
        this.visited.clear();
    }

    void graphSeek(HnswGraph graph, int level, int targetNode) throws IOException {
        graph.seek(level, targetNode);
    }

    int graphNextNeighbor(HnswGraph graph) throws IOException {
        return graph.nextNeighbor();
    }

    private static int getGraphSize(HnswGraph graph) {
        return graph.maxNodeId() + 1;
    }

    private static class OnHeapHnswGraphSearcher
    extends HnswGraphSearcher {
        private NeighborArray cur;
        private int upto;

        private OnHeapHnswGraphSearcher(NeighborQueue candidates, BitSet visited) {
            super(candidates, visited);
        }

        @Override
        void graphSeek(HnswGraph graph, int level, int targetNode) {
            this.cur = ((OnHeapHnswGraph)graph).getNeighbors(level, targetNode);
            this.upto = -1;
        }

        @Override
        int graphNextNeighbor(HnswGraph graph) {
            if (++this.upto < this.cur.size()) {
                return this.cur.node[this.upto];
            }
            return Integer.MAX_VALUE;
        }
    }
}

