/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Accountable;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.HnswGraph;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.NeighborArray;

public final class OnHeapHnswGraph
extends HnswGraph
implements Accountable {
    private static final int INIT_SIZE = 128;
    private final AtomicReference<EntryNode> entryNode;
    private NeighborArray[][] graph;
    private List<Integer>[] levelToNodes;
    private int lastFreezeSize;
    private final AtomicInteger size = new AtomicInteger(0);
    private final AtomicInteger nonZeroLevelSize = new AtomicInteger(0);
    private final AtomicInteger maxNodeId = new AtomicInteger(-1);
    private final int nsize;
    private final int nsize0;
    private final boolean noGrowth;
    private int upto;
    private NeighborArray cur;

    OnHeapHnswGraph(int M, int numNodes) {
        this.entryNode = new AtomicReference<EntryNode>(new EntryNode(-1, 1));
        this.nsize = M + 1;
        this.nsize0 = M * 2 + 1;
        boolean bl = this.noGrowth = numNodes != -1;
        if (!this.noGrowth) {
            numNodes = 128;
        }
        this.graph = new NeighborArray[numNodes][];
    }

    public NeighborArray getNeighbors(int level, int node) {
        assert (this.graph[node][level] != null);
        return this.graph[node][level];
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public int maxNodeId() {
        if (this.noGrowth) {
            return this.graph.length - 1;
        }
        return this.maxNodeId.get();
    }

    public void addNode(int level, int node) {
        if (node >= this.graph.length) {
            if (this.noGrowth) {
                throw new IllegalStateException("The graph does not expect to grow when an initial size is given");
            }
            this.graph = (NeighborArray[][])ArrayUtil.grow(this.graph, node + 1);
        }
        assert (this.graph[node] == null || this.graph[node].length > level) : "node must be inserted from the top level";
        if (this.graph[node] == null) {
            this.graph[node] = new NeighborArray[level + 1];
            this.size.incrementAndGet();
        }
        if (level == 0) {
            this.graph[node][level] = new NeighborArray(this.nsize0, true);
        } else {
            this.graph[node][level] = new NeighborArray(this.nsize, true);
            this.nonZeroLevelSize.incrementAndGet();
        }
        this.maxNodeId.accumulateAndGet(node, Math::max);
    }

    @Override
    public void seek(int level, int targetNode) {
        this.cur = this.getNeighbors(level, targetNode);
        this.upto = -1;
    }

    @Override
    public int nextNeighbor() {
        if (++this.upto < this.cur.size()) {
            return this.cur.node[this.upto];
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int numLevels() {
        return this.entryNode.get().level + 1;
    }

    @Override
    public int entryNode() {
        return this.entryNode.get().node;
    }

    public boolean trySetNewEntryNode(int node, int level) {
        EntryNode current = this.entryNode.get();
        if (current.node == -1) {
            return this.entryNode.compareAndSet(current, new EntryNode(node, level));
        }
        return false;
    }

    public boolean tryPromoteNewEntryNode(int node, int level, int expectOldLevel) {
        assert (level > expectOldLevel);
        EntryNode currentEntry = this.entryNode.get();
        if (currentEntry.level == expectOldLevel) {
            return this.entryNode.compareAndSet(currentEntry, new EntryNode(node, level));
        }
        return false;
    }

    @Override
    public HnswGraph.NodesIterator getNodesOnLevel(int level) {
        if (this.size() != this.maxNodeId() + 1) {
            throw new IllegalStateException("graph build not complete, size=" + this.size() + " maxNodeId=" + this.maxNodeId());
        }
        if (level == 0) {
            return new HnswGraph.ArrayNodesIterator(this.size());
        }
        this.generateLevelToNodes();
        return new HnswGraph.CollectionNodesIterator(this.levelToNodes[level]);
    }

    private void generateLevelToNodes() {
        if (this.lastFreezeSize == this.size()) {
            return;
        }
        int maxLevels = this.numLevels();
        this.levelToNodes = new List[maxLevels];
        for (int i = 1; i < maxLevels; ++i) {
            this.levelToNodes[i] = new ArrayList<Integer>();
        }
        int nonNullNode = 0;
        for (int node = 0; node < this.graph.length; ++node) {
            if (this.graph[node] == null) continue;
            ++nonNullNode;
            for (int i = 1; i < this.graph[node].length; ++i) {
                this.levelToNodes[i].add(node);
            }
            if (nonNullNode == this.size()) break;
        }
        this.lastFreezeSize = this.size();
    }

    @Override
    public long ramBytesUsed() {
        long neighborArrayBytes0 = (long)this.nsize0 * 8L + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * 2L + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2L + 12L;
        long neighborArrayBytes = (long)this.nsize * 8L + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * 2L + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2L + 12L;
        long total = 0L;
        total += (long)this.size() * (neighborArrayBytes0 + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        total += (long)this.nonZeroLevelSize.get() * neighborArrayBytes;
        total += 16L;
        ++total;
        total += (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8);
        total += 3L * (long)(4 + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER);
        total += (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        total += (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        if (this.levelToNodes != null) {
            total += (long)(this.numLevels() - 1) * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            total += (long)this.nonZeroLevelSize.get() * (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4);
        }
        return total;
    }

    public String toString() {
        return "OnHeapHnswGraph(size=" + this.size() + ", numLevels=" + this.numLevels() + ", entryNode=" + this.entryNode() + ")";
    }

    private static final class EntryNode {
        private final int node;
        private final int level;

        private EntryNode(int node, int level) {
            this.node = node;
            this.level = level;
        }
    }
}

