/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorSimilarityFunction;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.RandomAccessVectorValues;

public interface RandomVectorScorer {
    public float score(int var1) throws IOException;

    public int maxOrd();

    default public int ordToDoc(int ord) {
        return ord;
    }

    default public Bits getAcceptOrds(Bits acceptDocs) {
        return acceptDocs;
    }

    public static RandomVectorScorer createFloats(final RandomAccessVectorValues<float[]> vectors, final VectorSimilarityFunction similarityFunction, final float[] query) {
        if (query.length != vectors.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + query.length + " differs from field dimension: " + vectors.dimension());
        }
        return new AbstractRandomVectorScorer<float[]>(vectors){

            @Override
            public float score(int node) throws IOException {
                return similarityFunction.compare(query, (float[])vectors.vectorValue(node));
            }
        };
    }

    public static RandomVectorScorer createBytes(final RandomAccessVectorValues<byte[]> vectors, final VectorSimilarityFunction similarityFunction, final byte[] query) {
        if (query.length != vectors.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + query.length + " differs from field dimension: " + vectors.dimension());
        }
        return new AbstractRandomVectorScorer<byte[]>(vectors){

            @Override
            public float score(int node) throws IOException {
                return similarityFunction.compare(query, (byte[])vectors.vectorValue(node));
            }
        };
    }

    public static abstract class AbstractRandomVectorScorer<T>
    implements RandomVectorScorer {
        private final RandomAccessVectorValues<T> values;

        public AbstractRandomVectorScorer(RandomAccessVectorValues<T> values) {
            this.values = values;
        }

        @Override
        public int maxOrd() {
            return this.values.size();
        }

        @Override
        public int ordToDoc(int ord) {
            return this.values.ordToDoc(ord);
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return this.values.getAcceptOrds(acceptDocs);
        }
    }
}

