/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.upgrade.post;

import java.io.IOException;
import java.text.ParseException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;

class ShardUpgradeResult
implements Writeable {
    private ShardId shardId;
    private org.graylog.shaded.opensearch2.org.apache.lucene.util.Version oldestLuceneSegment;
    private Version upgradeVersion;
    private boolean primary;

    ShardUpgradeResult(ShardId shardId, boolean primary, Version upgradeVersion, org.graylog.shaded.opensearch2.org.apache.lucene.util.Version oldestLuceneSegment) {
        this.shardId = shardId;
        this.primary = primary;
        this.upgradeVersion = upgradeVersion;
        this.oldestLuceneSegment = oldestLuceneSegment;
    }

    ShardUpgradeResult(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.primary = in.readBoolean();
        this.upgradeVersion = in.readVersion();
        try {
            this.oldestLuceneSegment = org.graylog.shaded.opensearch2.org.apache.lucene.util.Version.parse(in.readString());
        }
        catch (ParseException ex) {
            throw new IOException("failed to parse lucene version [" + String.valueOf(this.oldestLuceneSegment) + "]", ex);
        }
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public org.graylog.shaded.opensearch2.org.apache.lucene.util.Version oldestLuceneSegment() {
        return this.oldestLuceneSegment;
    }

    public Version upgradeVersion() {
        return this.upgradeVersion;
    }

    public boolean primary() {
        return this.primary;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeBoolean(this.primary);
        out.writeVersion(this.upgradeVersion);
        out.writeString(this.oldestLuceneSegment.toString());
    }
}

