/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.get;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.graylog.shaded.opensearch2.org.opensearch.action.RoutingMissingException;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.MultiGetItemResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.MultiGetRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.MultiGetResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.MultiGetShardRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.MultiGetShardResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.get.TransportShardMultiGetAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.HandledTransportAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.Preference;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AtomicArray;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportMultiGetAction
extends HandledTransportAction<MultiGetRequest, MultiGetResponse> {
    private final ClusterService clusterService;
    private final TransportShardMultiGetAction shardAction;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportMultiGetAction(TransportService transportService, ClusterService clusterService, TransportShardMultiGetAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver resolver) {
        super("indices:data/read/mget", transportService, actionFilters, MultiGetRequest::new);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        this.indexNameExpressionResolver = resolver;
    }

    protected static boolean shouldForcePrimaryRouting(Metadata metadata, boolean realtime, String preference, String indexName) {
        return metadata.isSegmentReplicationEnabled(indexName) && realtime && preference == null;
    }

    @Override
    protected void doExecute(Task task, MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        AtomicArray<MultiGetItemResponse> responses = new AtomicArray<MultiGetItemResponse>(request.items.size());
        HashMap<ShardId, MultiGetShardRequest> shardRequests = new HashMap<ShardId, MultiGetShardRequest>();
        for (int i = 0; i < request.items.size(); ++i) {
            String concreteSingleIndex;
            MultiGetRequest.Item item;
            block7: {
                item = request.items.get(i);
                try {
                    concreteSingleIndex = this.indexNameExpressionResolver.concreteSingleIndex(clusterState, item).getName();
                    item.routing(clusterState.metadata().resolveIndexRouting(item.routing(), item.index()));
                    if (item.routing() == null && clusterState.getMetadata().routingRequired(concreteSingleIndex)) {
                        responses.set(i, TransportMultiGetAction.newItemFailure(concreteSingleIndex, item.id(), new RoutingMissingException(concreteSingleIndex, item.id())));
                    }
                    break block7;
                }
                catch (Exception e) {
                    responses.set(i, TransportMultiGetAction.newItemFailure(item.index(), item.id(), e));
                }
                continue;
            }
            ShardId shardId = this.clusterService.operationRouting().getShards(clusterState, concreteSingleIndex, item.id(), item.routing(), null).shardId();
            MultiGetShardRequest shardRequest = (MultiGetShardRequest)shardRequests.get(shardId);
            if (shardRequest == null) {
                if (TransportMultiGetAction.shouldForcePrimaryRouting(clusterState.getMetadata(), request.realtime(), request.preference(), concreteSingleIndex)) {
                    request.preference(Preference.PRIMARY.type());
                }
                shardRequest = new MultiGetShardRequest(request, shardId.getIndexName(), shardId.getId());
                shardRequests.put(shardId, shardRequest);
            }
            shardRequest.add(i, item);
        }
        if (shardRequests.isEmpty()) {
            listener.onResponse(new MultiGetResponse(responses.toArray((MultiGetItemResponse[])new MultiGetItemResponse[responses.length()])));
        }
        this.executeShardAction(listener, responses, shardRequests);
    }

    protected void executeShardAction(final ActionListener<MultiGetResponse> listener, final AtomicArray<MultiGetItemResponse> responses, Map<ShardId, MultiGetShardRequest> shardRequests) {
        final AtomicInteger counter = new AtomicInteger(shardRequests.size());
        for (final MultiGetShardRequest shardRequest : shardRequests.values()) {
            this.shardAction.execute(shardRequest, new ActionListener<MultiGetShardResponse>(){

                @Override
                public void onResponse(MultiGetShardResponse response) {
                    for (int i = 0; i < response.locations.size(); ++i) {
                        MultiGetItemResponse itemResponse = new MultiGetItemResponse(response.responses.get(i), response.failures.get(i));
                        responses.set(response.locations.get(i), itemResponse);
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    for (int i = 0; i < shardRequest.locations.size(); ++i) {
                        MultiGetRequest.Item item = shardRequest.items.get(i);
                        responses.set(shardRequest.locations.get(i), TransportMultiGetAction.newItemFailure(shardRequest.index(), item.id(), e));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse(new MultiGetResponse(responses.toArray(new MultiGetItemResponse[responses.length()])));
                }
            });
        }
    }

    private static MultiGetItemResponse newItemFailure(String index, String id, Exception exception) {
        return new MultiGetItemResponse(null, new MultiGetResponse.Failure(index, id, exception));
    }
}

