/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.AbstractSearchAsyncAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.ArraySearchPhaseResults;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.DfsQueryPhase;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.FetchSearchPhase;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.QueryPhaseResultConsumer;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhase;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseContext;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseController;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseName;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseResults;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchProgressListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequestContext;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchShardIterator;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchTask;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchTransportService;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.TransportSearchAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.GroupShardsIterator;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchPhaseResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchShardTarget;
import org.graylog.shaded.opensearch2.org.opensearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.dfs.AggregatedDfs;
import org.graylog.shaded.opensearch2.org.opensearch.search.dfs.DfsSearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.AliasFilter;
import org.graylog.shaded.opensearch2.org.opensearch.transport.Transport;

final class SearchDfsQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    private final SearchPhaseController searchPhaseController;
    private final QueryPhaseResultConsumer queryPhaseResultConsumer;

    SearchDfsQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, SearchPhaseController searchPhaseController, Executor executor, QueryPhaseResultConsumer queryPhaseResultConsumer, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, SearchResponse.Clusters clusters, SearchRequestContext searchRequestContext) {
        super(SearchPhaseName.DFS_PRE_QUERY.getName(), logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterState, task, new ArraySearchPhaseResults(shardsIts.size()), request.getMaxConcurrentShardRequests(), clusters, searchRequestContext);
        this.queryPhaseResultConsumer = queryPhaseResultConsumer;
        this.searchPhaseController = searchPhaseController;
        SearchProgressListener progressListener = task.getProgressListener();
        SearchSourceBuilder sourceBuilder = request.source();
        progressListener.notifyListShards(SearchProgressListener.buildSearchShards(this.shardsIts), SearchProgressListener.buildSearchShards(this.toSkipShardsIts), clusters, sourceBuilder == null || sourceBuilder.size() != 0);
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, SearchShardTarget shard, SearchActionListener<DfsSearchResult> listener) {
        this.getSearchTransport().sendExecuteDfs(this.getConnection(shard.getClusterAlias(), shard.getNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(SearchPhaseResults<DfsSearchResult> results, SearchPhaseContext context) {
        List<DfsSearchResult> dfsSearchResults = results.getAtomicArray().asList();
        AggregatedDfs aggregatedDfs = this.searchPhaseController.aggregateDfs(dfsSearchResults);
        return new DfsQueryPhase(dfsSearchResults, aggregatedDfs, this.queryPhaseResultConsumer, queryResults -> new FetchSearchPhase((SearchPhaseResults<SearchPhaseResult>)queryResults, this.searchPhaseController, aggregatedDfs, context), context);
    }
}

