/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.update;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.ResourceAlreadyExistsException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.action.RoutingMissingException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.TransportSingleItemBulkWriteAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.delete.DeleteRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.index.IndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.AutoCreateIndex;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.TransportActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.single.instance.TransportInstanceSingleOperationAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.update.UpdateHelper;
import org.graylog.shaded.opensearch2.org.opensearch.action.update.UpdateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.update.UpdateResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.PlainShardIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentHelper;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NotSerializableExceptionWrapper;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaType;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexService;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.VersionConflictEngineException;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexingStats;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportUpdateAction
extends TransportInstanceSingleOperationAction<UpdateRequest, UpdateResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final UpdateHelper updateHelper;
    private final IndicesService indicesService;
    private final NodeClient client;
    private final ClusterService clusterService;

    @Inject
    public TransportUpdateAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, UpdateHelper updateHelper, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, AutoCreateIndex autoCreateIndex, NodeClient client) {
        super("indices:data/write/update", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, UpdateRequest::new);
        this.updateHelper = updateHelper;
        this.indicesService = indicesService;
        this.autoCreateIndex = autoCreateIndex;
        this.client = client;
        this.clusterService = clusterService;
    }

    @Override
    protected String executor(ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().getIndexMetadata().isSystem() ? "system_write" : "write";
    }

    @Override
    protected UpdateResponse newResponse(StreamInput in) throws IOException {
        return new UpdateResponse(in);
    }

    @Override
    protected boolean retryOnFailure(Exception e) {
        return TransportActions.isShardNotAvailableException(e);
    }

    @Override
    protected void resolveRequest(ClusterState state, UpdateRequest request) {
        TransportUpdateAction.resolveAndValidateRouting(state.metadata(), request.concreteIndex(), request);
    }

    public static void resolveAndValidateRouting(Metadata metadata, String concreteIndex, UpdateRequest request) {
        request.routing(metadata.resolveWriteIndexRouting(request.routing(), request.index()));
        if (request.routing() == null && metadata.routingRequired(concreteIndex)) {
            throw new RoutingMissingException(concreteIndex, request.id());
        }
    }

    @Override
    protected void doExecute(final Task task, final UpdateRequest request, final ActionListener<UpdateResponse> listener) {
        if (request.isRequireAlias() && !this.clusterService.state().getMetadata().hasAlias(request.index())) {
            IndexNotFoundException e = new IndexNotFoundException("[require_alias] request flag is [true] and [" + request.index() + "] is not an alias", request.index());
            this.incDocStatusStats(e);
            throw e;
        }
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), this.clusterService.state())) {
            this.client.admin().indices().create((CreateIndexRequest)new CreateIndexRequest().index(request.index()).cause("auto(update api)").clusterManagerNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportUpdateAction.this.innerExecute(task, request, listener);
                }

                @Override
                public void onFailure(Exception e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                        try {
                            TransportUpdateAction.this.innerExecute(task, request, listener);
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            listener.onFailure(inner);
                        }
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(task, request, listener);
        }
    }

    private void innerExecute(Task task, UpdateRequest request, ActionListener<UpdateResponse> listener) {
        super.doExecute(task, request, ActionListener.wrap(listener::onResponse, e -> {
            this.incDocStatusStats((Exception)e);
            listener.onFailure((Exception)e);
        }));
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, UpdateRequest request) {
        ShardRouting shard;
        if (request.getShardId() != null) {
            return clusterState.routingTable().index(request.concreteIndex()).shard(request.getShardId().getId()).primaryShardIt();
        }
        ShardIterator shardIterator = this.clusterService.operationRouting().indexShards(clusterState, request.concreteIndex(), request.id(), request.routing());
        while ((shard = shardIterator.nextOrNull()) != null) {
            if (!shard.primary()) continue;
            return new PlainShardIterator(shardIterator.shardId(), Collections.singletonList(shard));
        }
        return new PlainShardIterator(shardIterator.shardId(), Collections.emptyList());
    }

    @Override
    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        this.shardOperation(request, listener, 0);
    }

    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener, int retryCount) {
        ShardId shardId = request.getShardId();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.getId());
        UpdateHelper.Result result = this.updateHelper.prepare(request, indexShard, this.threadPool::absoluteTimeInMillis);
        switch (result.getResponseResult()) {
            case CREATED: {
                IndexRequest upsertRequest = (IndexRequest)result.action();
                BytesReference upsertSourceBytes = upsertRequest.source();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(upsertRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    if (request.fetchSource() != null && request.fetchSource().fetchSource()) {
                        Tuple<? extends MediaType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(upsertSourceBytes, true, upsertRequest.getContentType());
                        update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), sourceAndContent.v2(), sourceAndContent.v1(), upsertSourceBytes));
                    } else {
                        update.setGetResult(null);
                    }
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case UPDATED: {
                IndexRequest indexRequest = (IndexRequest)result.action();
                BytesReference indexSourceBytes = indexRequest.source();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(indexRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), indexSourceBytes));
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case DELETED: {
                DeleteRequest deleteRequest = (DeleteRequest)result.action();
                this.client.bulk(TransportSingleItemBulkWriteAction.toSingleItemBulkRequest(deleteRequest), TransportSingleItemBulkWriteAction.wrapBulkResponse(ActionListener.wrap(response -> {
                    UpdateResponse update = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.getResult());
                    update.setGetResult(UpdateHelper.extractGetResult(request, request.concreteIndex(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), null));
                    update.setForcedRefresh(response.forcedRefresh());
                    listener.onResponse(update);
                }, exception -> this.handleUpdateFailureWithRetry(listener, request, (Exception)exception, retryCount))));
                break;
            }
            case NOOP: {
                IndexShard shard;
                UpdateResponse update = (UpdateResponse)result.action();
                IndexService indexServiceOrNull = this.indicesService.indexService(shardId.getIndex());
                if (indexServiceOrNull != null && (shard = indexService.getShardOrNull(shardId.getId())) != null) {
                    shard.noopUpdate();
                }
                IndexingStats.Stats.DocStatusStats stats = new IndexingStats.Stats.DocStatusStats();
                stats.inc(RestStatus.OK);
                this.indicesService.addDocStatusStats(stats);
                listener.onResponse(update);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal result " + String.valueOf(result.getResponseResult()));
            }
        }
    }

    private void handleUpdateFailureWithRetry(ActionListener<UpdateResponse> listener, UpdateRequest request, Exception failure, int retryCount) {
        Throwable cause = ExceptionsHelper.unwrapCause(failure);
        if (cause instanceof VersionConflictEngineException && retryCount < request.retryOnConflict()) {
            this.logger.trace("Retry attempt [{}] of [{}] on version conflict on [{}][{}][{}]", (Object)(retryCount + 1), (Object)request.retryOnConflict(), (Object)request.index(), (Object)request.getShardId(), (Object)request.id());
            this.threadPool.executor(this.executor(request.getShardId())).execute(ActionRunnable.wrap(listener, l -> this.shardOperation(request, (ActionListener<UpdateResponse>)l, retryCount + 1)));
            return;
        }
        listener.onFailure(cause instanceof Exception ? (Exception)cause : new NotSerializableExceptionWrapper(cause));
    }

    private void incDocStatusStats(Exception e) {
        IndexingStats.Stats.DocStatusStats stats = new IndexingStats.Stats.DocStatusStats();
        stats.inc(ExceptionsHelper.status(e));
        this.indicesService.addDocStatusStats(stats);
    }
}

