/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.common.SuppressForbidden;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class ElectionSchedulerFactory {
    private static final Logger logger = LogManager.getLogger(ElectionSchedulerFactory.class);
    private static final String ELECTION_INITIAL_TIMEOUT_SETTING_KEY = "cluster.election.initial_timeout";
    private static final String ELECTION_BACK_OFF_TIME_SETTING_KEY = "cluster.election.back_off_time";
    private static final String ELECTION_MAX_TIMEOUT_SETTING_KEY = "cluster.election.max_timeout";
    private static final String ELECTION_DURATION_SETTING_KEY = "cluster.election.duration";
    public static final Setting<TimeValue> ELECTION_INITIAL_TIMEOUT_SETTING = Setting.timeSetting("cluster.election.initial_timeout", TimeValue.timeValueMillis(100L), TimeValue.timeValueMillis(1L), TimeValue.timeValueSeconds(10L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> ELECTION_BACK_OFF_TIME_SETTING = Setting.timeSetting("cluster.election.back_off_time", TimeValue.timeValueMillis(100L), TimeValue.timeValueMillis(1L), TimeValue.timeValueSeconds(60L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> ELECTION_MAX_TIMEOUT_SETTING = Setting.timeSetting("cluster.election.max_timeout", TimeValue.timeValueSeconds(10L), TimeValue.timeValueMillis(200L), TimeValue.timeValueSeconds(300L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> ELECTION_DURATION_SETTING = Setting.timeSetting("cluster.election.duration", TimeValue.timeValueMillis(500L), TimeValue.timeValueMillis(1L), TimeValue.timeValueSeconds(300L), Setting.Property.NodeScope);
    private final TimeValue initialTimeout;
    private final TimeValue backoffTime;
    private final TimeValue maxTimeout;
    private final TimeValue duration;
    private final ThreadPool threadPool;
    private final Random random;

    public ElectionSchedulerFactory(Settings settings, Random random, ThreadPool threadPool) {
        this.random = random;
        this.threadPool = threadPool;
        this.initialTimeout = ELECTION_INITIAL_TIMEOUT_SETTING.get(settings);
        this.backoffTime = ELECTION_BACK_OFF_TIME_SETTING.get(settings);
        this.maxTimeout = ELECTION_MAX_TIMEOUT_SETTING.get(settings);
        this.duration = ELECTION_DURATION_SETTING.get(settings);
        if (this.maxTimeout.millis() < this.initialTimeout.millis()) {
            throw new IllegalArgumentException(new ParameterizedMessage("[{}] is [{}], but must be at least [{}] which is [{}]", new Object[]{ELECTION_MAX_TIMEOUT_SETTING_KEY, this.maxTimeout, ELECTION_INITIAL_TIMEOUT_SETTING_KEY, this.initialTimeout}).getFormattedMessage());
        }
    }

    public Releasable startElectionScheduler(TimeValue gracePeriod, Runnable scheduledRunnable) {
        ElectionScheduler scheduler = new ElectionScheduler();
        scheduler.scheduleNextElection(gracePeriod, scheduledRunnable);
        return scheduler;
    }

    @SuppressForbidden(reason="Argument to Math.abs() is definitely not Long.MIN_VALUE")
    private static long nonNegative(long n) {
        return n == Long.MIN_VALUE ? 0L : Math.abs(n);
    }

    static long toPositiveLongAtMost(long randomNumber, long upperBound) {
        assert (0L < upperBound) : upperBound;
        return ElectionSchedulerFactory.nonNegative(randomNumber) % upperBound + 1L;
    }

    public String toString() {
        return "ElectionSchedulerFactory{initialTimeout=" + String.valueOf(this.initialTimeout) + ", backoffTime=" + String.valueOf(this.backoffTime) + ", maxTimeout=" + String.valueOf(this.maxTimeout) + "}";
    }

    private class ElectionScheduler
    implements Releasable {
        private final AtomicBoolean isClosed = new AtomicBoolean();
        private final AtomicLong attempt = new AtomicLong();

        private ElectionScheduler() {
        }

        void scheduleNextElection(final TimeValue gracePeriod, final Runnable scheduledRunnable) {
            if (this.isClosed.get()) {
                logger.debug("{} not scheduling election", (Object)this);
                return;
            }
            final long thisAttempt = this.attempt.getAndIncrement();
            final long maxDelayMillis = Math.min(ElectionSchedulerFactory.this.maxTimeout.millis(), ElectionSchedulerFactory.this.initialTimeout.millis() + thisAttempt * ElectionSchedulerFactory.this.backoffTime.millis());
            final long delayMillis = ElectionSchedulerFactory.toPositiveLongAtMost(ElectionSchedulerFactory.this.random.nextLong(), maxDelayMillis) + gracePeriod.millis();
            AbstractRunnable runnable = new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.debug((Message)new ParameterizedMessage("unexpected exception in wakeup of {}", (Object)this), (Throwable)e);
                    assert (false) : e;
                }

                @Override
                protected void doRun() {
                    if (ElectionScheduler.this.isClosed.get()) {
                        logger.debug("{} not starting election", (Object)this);
                    } else {
                        logger.debug("{} starting election", (Object)this);
                        ElectionScheduler.this.scheduleNextElection(ElectionSchedulerFactory.this.duration, scheduledRunnable);
                        scheduledRunnable.run();
                    }
                }

                public String toString() {
                    return "scheduleNextElection{gracePeriod=" + String.valueOf(gracePeriod) + ", thisAttempt=" + thisAttempt + ", maxDelayMillis=" + maxDelayMillis + ", delayMillis=" + delayMillis + ", " + String.valueOf(ElectionScheduler.this) + "}";
                }
            };
            logger.debug("scheduling {}", (Object)runnable);
            ElectionSchedulerFactory.this.threadPool.scheduleUnlessShuttingDown(TimeValue.timeValueMillis(delayMillis), "generic", runnable);
        }

        public String toString() {
            return "ElectionScheduler{attempt=" + String.valueOf(this.attempt) + ", " + String.valueOf(ElectionSchedulerFactory.this) + "}";
        }

        @Override
        public void close() {
            boolean wasNotPreviouslyClosed = this.isClosed.compareAndSet(false, true);
            assert (wasNotPreviouslyClosed);
        }
    }
}

