/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata;

import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.AliasMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.admin.indices.AliasesNotFoundException;

public abstract class AliasAction {
    private final String index;

    private AliasAction(String index) {
        if (!Strings.hasText(index)) {
            throw new IllegalArgumentException("[index] is required");
        }
        this.index = index;
    }

    public String getIndex() {
        return this.index;
    }

    abstract boolean removeIndex();

    abstract boolean apply(NewAliasValidator var1, Metadata.Builder var2, IndexMetadata var3);

    public static class RemoveIndex
    extends AliasAction {
        public RemoveIndex(String index) {
            super(index);
        }

        @Override
        boolean removeIndex() {
            return true;
        }

        @Override
        boolean apply(NewAliasValidator aliasValidator, Metadata.Builder metadata, IndexMetadata index) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Remove
    extends AliasAction {
        private final String alias;
        @Nullable
        private final Boolean mustExist;

        public Remove(String index, String alias, @Nullable Boolean mustExist) {
            super(index);
            if (!Strings.hasText(alias)) {
                throw new IllegalArgumentException("[alias] is required");
            }
            this.alias = alias;
            this.mustExist = mustExist;
        }

        public String getAlias() {
            return this.alias;
        }

        @Override
        boolean removeIndex() {
            return false;
        }

        @Override
        boolean apply(NewAliasValidator aliasValidator, Metadata.Builder metadata, IndexMetadata index) {
            if (!index.getAliases().containsKey(this.alias)) {
                if (this.mustExist != null && this.mustExist.booleanValue()) {
                    throw new AliasesNotFoundException(new String[]{this.alias});
                }
                return false;
            }
            metadata.put(IndexMetadata.builder(index).removeAlias(this.alias));
            return true;
        }
    }

    public static class Add
    extends AliasAction {
        private final String alias;
        @Nullable
        private final String filter;
        @Nullable
        private final String indexRouting;
        @Nullable
        private final String searchRouting;
        @Nullable
        private final Boolean writeIndex;
        @Nullable
        final Boolean isHidden;

        public Add(String index, String alias, @Nullable String filter, @Nullable String indexRouting, @Nullable String searchRouting, @Nullable Boolean writeIndex, @Nullable Boolean isHidden) {
            super(index);
            if (!Strings.hasText(alias)) {
                throw new IllegalArgumentException("[alias] is required");
            }
            this.alias = alias;
            this.filter = filter;
            this.indexRouting = indexRouting;
            this.searchRouting = searchRouting;
            this.writeIndex = writeIndex;
            this.isHidden = isHidden;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getFilter() {
            return this.filter;
        }

        public String getSearchRouting() {
            return this.searchRouting;
        }

        public String getIndexRouting() {
            return this.indexRouting;
        }

        public Boolean writeIndex() {
            return this.writeIndex;
        }

        @Nullable
        public Boolean isHidden() {
            return this.isHidden;
        }

        @Override
        boolean removeIndex() {
            return false;
        }

        @Override
        boolean apply(NewAliasValidator aliasValidator, Metadata.Builder metadata, IndexMetadata index) {
            aliasValidator.validate(this.alias, this.indexRouting, this.filter, this.writeIndex);
            AliasMetadata newAliasMd = AliasMetadata.newAliasMetadataBuilder(this.alias).filter(this.filter).indexRouting(this.indexRouting).searchRouting(this.searchRouting).writeIndex(this.writeIndex).isHidden(this.isHidden).build();
            AliasMetadata currentAliasMd = index.getAliases().get(this.alias);
            if (currentAliasMd != null && currentAliasMd.equals(newAliasMd)) {
                return false;
            }
            metadata.put(IndexMetadata.builder(index).putAlias(newAliasMd));
            return true;
        }
    }

    @FunctionalInterface
    public static interface NewAliasValidator {
        public void validate(String var1, @Nullable String var2, @Nullable String var3, @Nullable Boolean var4);
    }
}

