/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterInfoService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.RestoreInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.health.ClusterHealthStatus;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.health.ClusterStateHealth;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.AutoExpandReplicas;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.UnassignedInfo;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.FailedShard;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.IndexMetadataUpdater;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.MoveDecision;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.NodeAllocationResult;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingExplanations;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.ShardAllocationDecision;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.StaleShard;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.command.AllocationCommands;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.Decision;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.GatewayAllocator;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.PriorityComparator;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotsInfoService;

public class AllocationService {
    private static final Logger logger = LogManager.getLogger(AllocationService.class);
    private final AllocationDeciders allocationDeciders;
    private Map<String, ExistingShardsAllocator> existingShardsAllocators;
    private final ShardsAllocator shardsAllocator;
    private final ClusterInfoService clusterInfoService;
    private SnapshotsInfoService snapshotsInfoService;

    public AllocationService(AllocationDeciders allocationDeciders, GatewayAllocator gatewayAllocator, ShardsAllocator shardsAllocator, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService) {
        this(allocationDeciders, shardsAllocator, clusterInfoService, snapshotsInfoService);
        this.setExistingShardsAllocators(Collections.singletonMap("gateway_allocator", gatewayAllocator));
    }

    public AllocationService(AllocationDeciders allocationDeciders, ShardsAllocator shardsAllocator, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService) {
        this.allocationDeciders = allocationDeciders;
        this.shardsAllocator = shardsAllocator;
        this.clusterInfoService = clusterInfoService;
        this.snapshotsInfoService = snapshotsInfoService;
    }

    public void setExistingShardsAllocators(Map<String, ExistingShardsAllocator> existingShardsAllocators) {
        assert (this.existingShardsAllocators == null) : "cannot set allocators " + String.valueOf(existingShardsAllocators) + " twice";
        assert (!existingShardsAllocators.isEmpty()) : "must add at least one ExistingShardsAllocator";
        this.existingShardsAllocators = Collections.unmodifiableMap(existingShardsAllocators);
    }

    public ClusterState applyStartedShards(ClusterState clusterState, List<ShardRouting> startedShards) {
        assert (this.assertInitialized());
        if (startedShards.isEmpty()) {
            return clusterState;
        }
        RoutingNodes routingNodes = this.getMutableRoutingNodes(clusterState);
        routingNodes.unassigned().shuffle();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState, this.clusterInfoService.getClusterInfo(), this.snapshotsInfoService.snapshotShardSizes(), this.currentNanoTime());
        startedShards = new ArrayList<ShardRouting>(startedShards);
        startedShards.sort(Comparator.comparing(ShardRouting::primary));
        this.applyStartedShards(allocation, startedShards);
        for (ExistingShardsAllocator allocator : this.existingShardsAllocators.values()) {
            allocator.applyStartedShards(startedShards, allocation);
        }
        assert (RoutingNodes.assertShardStats(allocation.routingNodes()));
        String startedShardsAsString = AllocationService.firstListElementsToCommaDelimitedString(startedShards, s -> s.shardId().toString(), logger.isDebugEnabled());
        return this.buildResultAndLogHealthChange(clusterState, allocation, "shards started [" + startedShardsAsString + "]");
    }

    protected ClusterState buildResultAndLogHealthChange(ClusterState oldState, RoutingAllocation allocation, String reason) {
        ClusterState newState = this.buildResult(oldState, allocation);
        this.logClusterHealthStateChange(new ClusterStateHealth(oldState), new ClusterStateHealth(newState), reason);
        return newState;
    }

    private ClusterState buildResult(ClusterState oldState, RoutingAllocation allocation) {
        RestoreInProgress updatedRestoreInProgress;
        RoutingTable oldRoutingTable = oldState.routingTable();
        RoutingNodes newRoutingNodes = allocation.routingNodes();
        RoutingTable newRoutingTable = new RoutingTable.Builder().updateNodes(oldRoutingTable.version(), newRoutingNodes).build();
        Metadata newMetadata = allocation.updateMetadataWithRoutingChanges(newRoutingTable);
        assert (newRoutingTable.validate(newMetadata));
        ClusterState.Builder newStateBuilder = ClusterState.builder(oldState).routingTable(newRoutingTable).metadata(newMetadata);
        RestoreInProgress restoreInProgress = (RestoreInProgress)allocation.custom("restore");
        if (restoreInProgress != null && (updatedRestoreInProgress = allocation.updateRestoreInfoWithRoutingChanges(restoreInProgress)) != restoreInProgress) {
            HashMap<String, ClusterState.Custom> customsBuilder = new HashMap<String, ClusterState.Custom>(allocation.getCustoms());
            customsBuilder.put("restore", updatedRestoreInProgress);
            newStateBuilder.customs(customsBuilder);
        }
        return newStateBuilder.build();
    }

    public ClusterState applyFailedShard(ClusterState clusterState, ShardRouting failedShard, boolean markAsStale) {
        return this.applyFailedShards(clusterState, Collections.singletonList(new FailedShard(failedShard, null, null, markAsStale)), Collections.emptyList());
    }

    public ClusterState applyFailedShards(ClusterState clusterState, List<FailedShard> failedShards) {
        return this.applyFailedShards(clusterState, failedShards, Collections.emptyList());
    }

    public ClusterState applyFailedShards(ClusterState clusterState, List<FailedShard> failedShards, List<StaleShard> staleShards) {
        assert (this.assertInitialized());
        if (staleShards.isEmpty() && failedShards.isEmpty()) {
            return clusterState;
        }
        ClusterState tmpState = IndexMetadataUpdater.removeStaleIdsWithoutRoutings(clusterState, staleShards, logger);
        RoutingNodes routingNodes = this.getMutableRoutingNodes(tmpState);
        routingNodes.unassigned().shuffle();
        long currentNanoTime = this.currentNanoTime();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, tmpState, this.clusterInfoService.getClusterInfo(), this.snapshotsInfoService.snapshotShardSizes(), currentNanoTime);
        for (FailedShard failedShardEntry : failedShards) {
            ShardRouting shardToFail = failedShardEntry.getRoutingEntry();
            IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardToFail.shardId().getIndex());
            allocation.addIgnoreShardForNode(shardToFail.shardId(), shardToFail.currentNodeId());
            ShardRouting failedShard = routingNodes.getByAllocationId(shardToFail.shardId(), shardToFail.allocationId().getId());
            if (failedShard != null) {
                Set<String> failedNodeIds;
                int failedAllocations;
                if (failedShard != shardToFail) {
                    logger.trace("{} shard routing modified in an earlier iteration (previous: {}, current: {})", (Object)shardToFail.shardId(), (Object)shardToFail, (Object)failedShard);
                }
                int n = failedAllocations = failedShard.unassignedInfo() != null ? failedShard.unassignedInfo().getNumFailedAllocations() : 0;
                if (failedShard.unassignedInfo() != null) {
                    failedNodeIds = new HashSet(failedShard.unassignedInfo().getFailedNodeIds().size() + 1);
                    failedNodeIds.addAll(failedShard.unassignedInfo().getFailedNodeIds());
                    failedNodeIds.add(failedShard.currentNodeId());
                } else {
                    failedNodeIds = Collections.emptySet();
                }
                String message = "failed shard on node [" + shardToFail.currentNodeId() + "]: " + failedShardEntry.getMessage();
                UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.ALLOCATION_FAILED, message, failedShardEntry.getFailure(), failedAllocations + 1, currentNanoTime, System.currentTimeMillis(), false, UnassignedInfo.AllocationStatus.NO_ATTEMPT, failedNodeIds);
                if (failedShardEntry.markAsStale()) {
                    allocation.removeAllocationId(failedShard);
                }
                logger.warn((Message)new ParameterizedMessage("failing shard [{}]", (Object)failedShardEntry), (Throwable)failedShardEntry.getFailure());
                routingNodes.failShard(logger, failedShard, unassignedInfo, indexMetadata, allocation.changes());
                continue;
            }
            logger.trace("{} shard routing failed in an earlier iteration (routing: {})", (Object)shardToFail.shardId(), (Object)shardToFail);
        }
        for (ExistingShardsAllocator allocator : this.existingShardsAllocators.values()) {
            allocator.applyFailedShards(failedShards, allocation);
        }
        this.reroute(allocation);
        String failedShardsAsString = AllocationService.firstListElementsToCommaDelimitedString(failedShards, s -> s.getRoutingEntry().shardId().toString(), logger.isDebugEnabled());
        return this.buildResultAndLogHealthChange(clusterState, allocation, "shards failed [" + failedShardsAsString + "]");
    }

    public ClusterState disassociateDeadNodes(ClusterState clusterState, boolean reroute, String reason) {
        RoutingNodes routingNodes = this.getMutableRoutingNodes(clusterState);
        routingNodes.unassigned().shuffle();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState, this.clusterInfoService.getClusterInfo(), this.snapshotsInfoService.snapshotShardSizes(), this.currentNanoTime());
        this.disassociateDeadNodes(allocation);
        if (allocation.routingNodesChanged()) {
            clusterState = this.buildResult(clusterState, allocation);
        }
        if (reroute) {
            return this.reroute(clusterState, reason);
        }
        return clusterState;
    }

    public ClusterState adaptAutoExpandReplicas(ClusterState clusterState) {
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, clusterState.getRoutingNodes(), clusterState, this.clusterInfoService.getClusterInfo(), this.snapshotsInfoService.snapshotShardSizes(), this.currentNanoTime());
        Map<Integer, List<String>> autoExpandReplicaChanges = AutoExpandReplicas.getAutoExpandReplicaChanges(clusterState.metadata(), allocation);
        if (autoExpandReplicaChanges.isEmpty()) {
            return clusterState;
        }
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(clusterState.routingTable());
        Metadata.Builder metadataBuilder = Metadata.builder(clusterState.metadata());
        for (Map.Entry<Integer, List<String>> entry : autoExpandReplicaChanges.entrySet()) {
            int numberOfReplicas = entry.getKey();
            String[] indices = entry.getValue().toArray(new String[entry.getValue().size()]);
            routingTableBuilder.updateNumberOfReplicas(numberOfReplicas, indices);
            metadataBuilder.updateNumberOfReplicas(numberOfReplicas, indices);
            for (String index : indices) {
                IndexMetadata indexMetadata = metadataBuilder.get(index);
                IndexMetadata.Builder indexMetadataBuilder = new IndexMetadata.Builder(indexMetadata).settingsVersion(1L + indexMetadata.getSettingsVersion());
                metadataBuilder.put(indexMetadataBuilder);
            }
            logger.info("updating number_of_replicas to [{}] for indices {}", (Object)numberOfReplicas, (Object)indices);
        }
        ClusterState fixedState = ClusterState.builder(clusterState).routingTable(routingTableBuilder.build()).metadata(metadataBuilder).build();
        assert (AutoExpandReplicas.getAutoExpandReplicaChanges(fixedState.metadata(), allocation).isEmpty());
        return fixedState;
    }

    private void removeDelayMarkers(RoutingAllocation allocation) {
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = allocation.routingNodes().unassigned().iterator();
        Metadata metadata = allocation.metadata();
        while (unassignedIterator.hasNext()) {
            long newComputedLeftDelayNanos;
            ShardRouting shardRouting = unassignedIterator.next();
            UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
            if (!unassignedInfo.isDelayed() || (newComputedLeftDelayNanos = unassignedInfo.getRemainingDelay(allocation.getCurrentNanoTime(), metadata.getIndexSafe(shardRouting.index()).getSettings())) != 0L) continue;
            unassignedIterator.updateUnassigned(new UnassignedInfo(unassignedInfo.getReason(), unassignedInfo.getMessage(), unassignedInfo.getFailure(), unassignedInfo.getNumFailedAllocations(), unassignedInfo.getUnassignedTimeInNanos(), unassignedInfo.getUnassignedTimeInMillis(), false, unassignedInfo.getLastAllocationStatus(), unassignedInfo.getFailedNodeIds()), shardRouting.recoverySource(), allocation.changes());
        }
    }

    private void resetFailedAllocationCounter(RoutingAllocation allocation) {
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = allocation.routingNodes().unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            ShardRouting shardRouting = unassignedIterator.next();
            UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
            unassignedIterator.updateUnassigned(new UnassignedInfo(unassignedInfo.getNumFailedAllocations() > 0 ? UnassignedInfo.Reason.MANUAL_ALLOCATION : unassignedInfo.getReason(), unassignedInfo.getMessage(), unassignedInfo.getFailure(), 0, unassignedInfo.getUnassignedTimeInNanos(), unassignedInfo.getUnassignedTimeInMillis(), unassignedInfo.isDelayed(), unassignedInfo.getLastAllocationStatus(), Collections.emptySet()), shardRouting.recoverySource(), allocation.changes());
        }
    }

    public static <T> String firstListElementsToCommaDelimitedString(List<T> elements, Function<T, String> formatter, boolean isDebugEnabled) {
        int maxNumberOfElements = 10;
        if (isDebugEnabled || elements.size() <= 10) {
            return elements.stream().map(formatter).collect(Collectors.joining(", "));
        }
        return elements.stream().limit(10L).map(formatter).collect(Collectors.joining(", ")) + ", ... [" + elements.size() + " items in total]";
    }

    public CommandsResult reroute(ClusterState clusterState, AllocationCommands commands, boolean explain, boolean retryFailed) {
        RoutingNodes routingNodes = this.getMutableRoutingNodes(clusterState);
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState, this.clusterInfoService.getClusterInfo(), this.snapshotsInfoService.snapshotShardSizes(), this.currentNanoTime());
        allocation.debugDecision(true);
        allocation.ignoreDisable(true);
        if (retryFailed) {
            this.resetFailedAllocationCounter(allocation);
        }
        RoutingExplanations explanations = commands.execute(allocation, explain);
        allocation.ignoreDisable(false);
        this.reroute(allocation);
        return new CommandsResult(explanations, this.buildResultAndLogHealthChange(clusterState, allocation, "reroute commands"));
    }

    public ClusterState reroute(ClusterState clusterState, String reason) {
        ClusterState fixedClusterState = this.adaptAutoExpandReplicas(clusterState);
        RoutingNodes routingNodes = this.getMutableRoutingNodes(fixedClusterState);
        routingNodes.unassigned().shuffle();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, fixedClusterState, this.clusterInfoService.getClusterInfo(), this.snapshotsInfoService.snapshotShardSizes(), this.currentNanoTime());
        this.reroute(allocation);
        if (fixedClusterState == clusterState && !allocation.routingNodesChanged()) {
            return clusterState;
        }
        return this.buildResultAndLogHealthChange(clusterState, allocation, reason);
    }

    private void logClusterHealthStateChange(ClusterStateHealth previousStateHealth, ClusterStateHealth newStateHealth, String reason) {
        ClusterHealthStatus currentHealth;
        ClusterHealthStatus previousHealth = previousStateHealth.getStatus();
        if (!previousHealth.equals(currentHealth = newStateHealth.getStatus())) {
            logger.info("Cluster health status changed from [{}] to [{}] (reason: [{}]).", (Object)previousHealth, (Object)currentHealth, (Object)reason);
        }
    }

    private boolean hasDeadNodes(RoutingAllocation allocation) {
        for (RoutingNode routingNode : allocation.routingNodes()) {
            if (allocation.nodes().getDataNodes().containsKey(routingNode.nodeId())) continue;
            return true;
        }
        return false;
    }

    private void reroute(RoutingAllocation allocation) {
        assert (!this.hasDeadNodes(allocation)) : "dead nodes should be explicitly cleaned up. See disassociateDeadNodes";
        assert (AutoExpandReplicas.getAutoExpandReplicaChanges(allocation.metadata(), allocation).isEmpty()) : "auto-expand replicas out of sync with number of nodes in the cluster";
        assert (this.assertInitialized());
        this.removeDelayMarkers(allocation);
        this.allocateExistingUnassignedShards(allocation);
        this.shardsAllocator.allocate(allocation);
        assert (RoutingNodes.assertShardStats(allocation.routingNodes()));
    }

    private void allocateExistingUnassignedShards(RoutingAllocation allocation) {
        allocation.routingNodes().unassigned().sort(PriorityComparator.getAllocationComparator(allocation));
        for (ExistingShardsAllocator existingShardsAllocator : this.existingShardsAllocators.values()) {
            existingShardsAllocator.beforeAllocation(allocation);
        }
        RoutingNodes.UnassignedShards.UnassignedIterator primaryIterator = allocation.routingNodes().unassigned().iterator();
        while (primaryIterator.hasNext()) {
            ShardRouting shardRouting = primaryIterator.next();
            if (!shardRouting.primary()) continue;
            this.getAllocatorForShard(shardRouting, allocation).allocateUnassigned(shardRouting, allocation, primaryIterator);
        }
        for (ExistingShardsAllocator existingShardsAllocator : this.existingShardsAllocators.values()) {
            existingShardsAllocator.afterPrimariesBeforeReplicas(allocation);
        }
        RoutingNodes.UnassignedShards.UnassignedIterator replicaIterator = allocation.routingNodes().unassigned().iterator();
        while (replicaIterator.hasNext()) {
            ShardRouting shardRouting = replicaIterator.next();
            if (shardRouting.primary()) continue;
            this.getAllocatorForShard(shardRouting, allocation).allocateUnassigned(shardRouting, allocation, replicaIterator);
        }
    }

    private void disassociateDeadNodes(RoutingAllocation allocation) {
        Iterator<RoutingNode> it = allocation.routingNodes().mutableIterator();
        while (it.hasNext()) {
            RoutingNode node = it.next();
            if (allocation.nodes().getDataNodes().containsKey(node.nodeId())) continue;
            for (ShardRouting shardRouting : node.copyShards()) {
                IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
                boolean delayed = UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.get(indexMetadata.getSettings()).nanos() > 0L;
                UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.NODE_LEFT, "node_left [" + node.nodeId() + "]", null, 0, allocation.getCurrentNanoTime(), System.currentTimeMillis(), delayed, UnassignedInfo.AllocationStatus.NO_ATTEMPT, Collections.emptySet());
                allocation.routingNodes().failShard(logger, shardRouting, unassignedInfo, indexMetadata, allocation.changes());
            }
            it.remove();
        }
    }

    private void applyStartedShards(RoutingAllocation routingAllocation, List<ShardRouting> startedShardEntries) {
        assert (!startedShardEntries.isEmpty()) : "non-empty list of started shard entries expected";
        RoutingNodes routingNodes = routingAllocation.routingNodes();
        for (ShardRouting startedShard : startedShardEntries) {
            assert (startedShard.initializing()) : "only initializing shards can be started";
            assert (routingAllocation.metadata().index(startedShard.shardId().getIndex()) != null) : "shard started for unknown index (shard entry: " + String.valueOf(startedShard) + ")";
            assert (startedShard == routingNodes.getByAllocationId(startedShard.shardId(), startedShard.allocationId().getId())) : "shard routing to start does not exist in routing table, expected: " + String.valueOf(startedShard) + " but was: " + String.valueOf(routingNodes.getByAllocationId(startedShard.shardId(), startedShard.allocationId().getId()));
            routingNodes.startShard(logger, startedShard, routingAllocation.changes());
        }
    }

    private RoutingNodes getMutableRoutingNodes(ClusterState clusterState) {
        return new RoutingNodes(clusterState, false);
    }

    protected long currentNanoTime() {
        return System.nanoTime();
    }

    public void cleanCaches() {
        assert (this.assertInitialized());
        this.existingShardsAllocators.values().forEach(ExistingShardsAllocator::cleanCaches);
    }

    public int getNumberOfInFlightFetches() {
        assert (this.assertInitialized());
        return this.existingShardsAllocators.values().stream().mapToInt(ExistingShardsAllocator::getNumberOfInFlightFetches).sum();
    }

    public ShardAllocationDecision explainShardAllocation(ShardRouting shardRouting, RoutingAllocation allocation) {
        AllocateUnassignedDecision allocateDecision;
        assert (allocation.debugDecision());
        AllocateUnassignedDecision allocateUnassignedDecision = allocateDecision = shardRouting.unassigned() ? this.explainUnassignedShardAllocation(shardRouting, allocation) : AllocateUnassignedDecision.NOT_TAKEN;
        if (allocateDecision.isDecisionTaken()) {
            return new ShardAllocationDecision(allocateDecision, MoveDecision.NOT_TAKEN);
        }
        return this.shardsAllocator.decideShardAllocation(shardRouting, allocation);
    }

    private AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting shardRouting, RoutingAllocation routingAllocation) {
        assert (shardRouting.unassigned());
        assert (routingAllocation.debugDecision());
        assert (this.assertInitialized());
        ExistingShardsAllocator existingShardsAllocator = this.getAllocatorForShard(shardRouting, routingAllocation);
        AllocateUnassignedDecision decision = existingShardsAllocator.explainUnassignedShardAllocation(shardRouting, routingAllocation);
        if (decision.isDecisionTaken()) {
            return decision;
        }
        return AllocateUnassignedDecision.NOT_TAKEN;
    }

    private ExistingShardsAllocator getAllocatorForShard(ShardRouting shardRouting, RoutingAllocation routingAllocation) {
        assert (this.assertInitialized());
        String allocatorName = ExistingShardsAllocator.EXISTING_SHARDS_ALLOCATOR_SETTING.get(routingAllocation.metadata().getIndexSafe(shardRouting.index()).getSettings());
        ExistingShardsAllocator existingShardsAllocator = this.existingShardsAllocators.get(allocatorName);
        return existingShardsAllocator != null ? existingShardsAllocator : new NotFoundAllocator(allocatorName);
    }

    private boolean assertInitialized() {
        assert (this.existingShardsAllocators != null) : "must have set allocators first";
        return true;
    }

    public static class CommandsResult {
        private final RoutingExplanations explanations;
        private final ClusterState clusterState;

        private CommandsResult(RoutingExplanations explanations, ClusterState clusterState) {
            this.clusterState = clusterState;
            this.explanations = explanations;
        }

        public RoutingExplanations explanations() {
            return this.explanations;
        }

        public ClusterState getClusterState() {
            return this.clusterState;
        }
    }

    private static class NotFoundAllocator
    implements ExistingShardsAllocator {
        private final String allocatorName;

        private NotFoundAllocator(String allocatorName) {
            this.allocatorName = allocatorName;
        }

        @Override
        public void beforeAllocation(RoutingAllocation allocation) {
        }

        @Override
        public void afterPrimariesBeforeReplicas(RoutingAllocation allocation) {
        }

        @Override
        public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
            unassignedAllocationHandler.removeAndIgnore(UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, allocation.changes());
        }

        @Override
        public AllocateUnassignedDecision explainUnassignedShardAllocation(ShardRouting unassignedShard, RoutingAllocation allocation) {
            assert (unassignedShard.unassigned());
            assert (allocation.debugDecision());
            ArrayList<NodeAllocationResult> nodeAllocationResults = new ArrayList<NodeAllocationResult>(allocation.nodes().getSize());
            for (DiscoveryNode discoveryNode : allocation.nodes()) {
                nodeAllocationResults.add(new NodeAllocationResult(discoveryNode, null, allocation.decision(Decision.NO, "allocator_plugin", "finding the previous copies of this shard requires an allocator called [%s] but that allocator was not found; perhaps the corresponding plugin is not installed", this.allocatorName)));
            }
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, nodeAllocationResults);
        }

        @Override
        public void cleanCaches() {
        }

        @Override
        public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        }

        @Override
        public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        }

        @Override
        public int getNumberOfInFlightFetches() {
            return 0;
        }
    }
}

