/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider;

import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.Decision;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;

public class ClusterRebalanceAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(ClusterRebalanceAllocationDecider.class);
    public static final String NAME = "cluster_rebalance";
    private static final String CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE = "cluster.routing.allocation.allow_rebalance";
    public static final Setting<ClusterRebalanceType> CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE_SETTING = new Setting<ClusterRebalanceType>("cluster.routing.allocation.allow_rebalance", ClusterRebalanceType.INDICES_ALL_ACTIVE.toString(), ClusterRebalanceType::parseString, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile ClusterRebalanceType type;

    public ClusterRebalanceAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.type = CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE_SETTING.get(settings);
        logger.debug("using [{}] with [{}]", (Object)CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE, (Object)this.type);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE_SETTING, this::setType);
    }

    private void setType(ClusterRebalanceType type) {
        this.type = type;
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return this.canRebalance(allocation);
    }

    @Override
    public Decision canRebalance(RoutingAllocation allocation) {
        if (this.type == ClusterRebalanceType.INDICES_PRIMARIES_ACTIVE) {
            if (allocation.routingNodes().hasUnassignedPrimaries()) {
                return allocation.decision(Decision.NO, NAME, "the cluster has unassigned primary shards and cluster setting [%s] is set to [%s]", new Object[]{CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE, this.type});
            }
            if (allocation.routingNodes().hasInactivePrimaries()) {
                return allocation.decision(Decision.NO, NAME, "the cluster has inactive primary shards and cluster setting [%s] is set to [%s]", new Object[]{CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE, this.type});
            }
            return allocation.decision(Decision.YES, NAME, "all primary shards are active", new Object[0]);
        }
        if (this.type == ClusterRebalanceType.INDICES_ALL_ACTIVE) {
            if (allocation.routingNodes().hasUnassignedShards()) {
                return allocation.decision(Decision.NO, NAME, "the cluster has unassigned shards and cluster setting [%s] is set to [%s]", new Object[]{CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE, this.type});
            }
            if (allocation.routingNodes().hasInactiveShards()) {
                return allocation.decision(Decision.NO, NAME, "the cluster has inactive shards and cluster setting [%s] is set to [%s]", new Object[]{CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE, this.type});
            }
        }
        return allocation.decision(Decision.YES, NAME, "all shards are active", new Object[0]);
    }

    public static enum ClusterRebalanceType {
        ALWAYS,
        INDICES_PRIMARIES_ACTIVE,
        INDICES_ALL_ACTIVE;


        public static ClusterRebalanceType parseString(String typeString) {
            if ("always".equalsIgnoreCase(typeString)) {
                return ALWAYS;
            }
            if ("indices_primaries_active".equalsIgnoreCase(typeString) || "indicesPrimariesActive".equalsIgnoreCase(typeString)) {
                return INDICES_PRIMARIES_ACTIVE;
            }
            if ("indices_all_active".equalsIgnoreCase(typeString) || "indicesAllActive".equalsIgnoreCase(typeString)) {
                return INDICES_ALL_ACTIVE;
            }
            throw new IllegalArgumentException("Illegal value for " + String.valueOf(CLUSTER_ROUTING_ALLOCATION_ALLOW_REBALANCE_SETTING) + ": " + typeString);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

