/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.stream.write;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedConsumer;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.StreamContext;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.stream.write.StreamContextSupplier;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.stream.write.WritePriority;

public class WriteContext {
    private final String fileName;
    private final StreamContextSupplier streamContextSupplier;
    private final long fileSize;
    private final boolean failIfAlreadyExists;
    private final WritePriority writePriority;
    private final CheckedConsumer<Boolean, IOException> uploadFinalizer;
    private final boolean doRemoteDataIntegrityCheck;
    private final Long expectedChecksum;

    public WriteContext(String fileName, StreamContextSupplier streamContextSupplier, long fileSize, boolean failIfAlreadyExists, WritePriority writePriority, CheckedConsumer<Boolean, IOException> uploadFinalizer, boolean doRemoteDataIntegrityCheck, @Nullable Long expectedChecksum) {
        this.fileName = fileName;
        this.streamContextSupplier = streamContextSupplier;
        this.fileSize = fileSize;
        this.failIfAlreadyExists = failIfAlreadyExists;
        this.writePriority = writePriority;
        this.uploadFinalizer = uploadFinalizer;
        this.doRemoteDataIntegrityCheck = doRemoteDataIntegrityCheck;
        this.expectedChecksum = expectedChecksum;
    }

    protected WriteContext(WriteContext writeContext) {
        this.fileName = writeContext.fileName;
        this.streamContextSupplier = writeContext.streamContextSupplier;
        this.fileSize = writeContext.fileSize;
        this.failIfAlreadyExists = writeContext.failIfAlreadyExists;
        this.writePriority = writeContext.writePriority;
        this.uploadFinalizer = writeContext.uploadFinalizer;
        this.doRemoteDataIntegrityCheck = writeContext.doRemoteDataIntegrityCheck;
        this.expectedChecksum = writeContext.expectedChecksum;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isFailIfAlreadyExists() {
        return this.failIfAlreadyExists;
    }

    public StreamContext getStreamProvider(long partSize) {
        return this.streamContextSupplier.supplyStreamContext(partSize);
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public WritePriority getWritePriority() {
        return this.writePriority;
    }

    public CheckedConsumer<Boolean, IOException> getUploadFinalizer() {
        return this.uploadFinalizer;
    }

    public boolean doRemoteDataIntegrityCheck() {
        return this.doRemoteDataIntegrityCheck;
    }

    public Long getExpectedChecksum() {
        return this.expectedChecksum;
    }
}

