/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.metrics;

import java.util.concurrent.atomic.AtomicLong;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.CounterMetric;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.MeanMetric;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.OperationStats;

public class OperationMetrics {
    private final MeanMetric time = new MeanMetric();
    private final AtomicLong current = new AtomicLong();
    private final CounterMetric failed = new CounterMetric();

    public void before() {
        this.current.incrementAndGet();
    }

    public void after(long currentTime) {
        this.current.decrementAndGet();
        this.time.inc(currentTime);
    }

    public void failed() {
        this.failed.inc();
    }

    public void add(OperationMetrics other) {
        this.failed.inc(other.failed.count());
        this.time.add(other.time);
    }

    public OperationStats createStats() {
        return new OperationStats(this.time.count(), this.time.sum(), this.current.get(), this.failed.count());
    }
}

