/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.codec.fuzzy;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.DataOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Accountable;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedFunction;
import org.graylog.shaded.opensearch2.org.opensearch.index.codec.fuzzy.BloomFilter;

public interface FuzzySet
extends Accountable,
Closeable {
    public SetType setType();

    public Result contains(BytesRef var1);

    public boolean isSaturated();

    public void writeTo(DataOutput var1) throws IOException;

    public static enum SetType {
        BLOOM_FILTER_V1("bloom_filter_v1", BloomFilter::new, List.of("bloom_filter"));

        private final String setName;
        private final CheckedFunction<IndexInput, ? extends FuzzySet, IOException> deserializer;

        private SetType(String setName, CheckedFunction<IndexInput, ? extends FuzzySet, IOException> deserializer, List<String> aliases) {
            if (aliases.size() < 1) {
                throw new IllegalArgumentException("Alias list is empty. Could not create Set Type: " + setName);
            }
            this.setName = setName;
            this.deserializer = deserializer;
        }

        public String getSetName() {
            return this.setName;
        }

        public CheckedFunction<IndexInput, ? extends FuzzySet, IOException> getDeserializer() {
            return this.deserializer;
        }

        public static SetType from(String name) {
            for (SetType type : SetType.values()) {
                if (!type.setName.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("There is no implementation for fuzzy set: " + name);
        }
    }

    public static enum Result {
        NO,
        MAYBE;

    }
}

