/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.engine;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class ReplicaFileTracker {
    public static final Logger logger = LogManager.getLogger(ReplicaFileTracker.class);
    private final Map<String, Integer> refCounts = new HashMap<String, Integer>();
    private final BiConsumer<String, String> fileDeleter;
    private final Set<String> EXCLUDE_FILES = Set.of("write.lock");

    public ReplicaFileTracker(BiConsumer<String, String> fileDeleter) {
        this.fileDeleter = fileDeleter;
    }

    public synchronized void incRef(Collection<String> fileNames) {
        for (String fileName : fileNames) {
            this.refCounts.merge(fileName, 1, Integer::sum);
        }
    }

    public synchronized int refCount(String file) {
        return Optional.ofNullable(this.refCounts.get(file)).orElse(0);
    }

    public synchronized void decRef(Collection<String> fileNames) {
        HashSet<String> toDelete = new HashSet<String>();
        for (String fileName : fileNames) {
            Integer curCount = this.refCounts.get(fileName);
            assert (curCount != null) : "fileName=" + fileName;
            assert (curCount > 0);
            if (curCount == 1) {
                this.refCounts.remove(fileName);
                toDelete.add(fileName);
                continue;
            }
            this.refCounts.put(fileName, curCount - 1);
        }
        if (!toDelete.isEmpty()) {
            this.delete(toDelete);
        }
    }

    public void deleteUnreferencedFiles(String ... toDelete) {
        for (String file : toDelete) {
            if (!this.canDelete(file)) continue;
            this.delete(file);
        }
    }

    private synchronized void delete(Collection<String> toDelete) {
        for (String fileName : toDelete) {
            this.delete(fileName);
        }
    }

    private synchronized void delete(String fileName) {
        assert (this.canDelete(fileName));
        this.fileDeleter.accept("delete unreferenced", fileName);
    }

    private synchronized boolean canDelete(String fileName) {
        return !this.EXCLUDE_FILES.contains(fileName) && !this.refCounts.containsKey(fileName);
    }
}

