/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.fielddata;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DoubleValues;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.AbstractNumericDocValues;

@PublicApi(since="1.0.0")
public abstract class NumericDoubleValues
extends DoubleValues {
    protected NumericDoubleValues() {
    }

    public NumericDocValues getRawDoubleValues() {
        return new AbstractNumericDocValues(){
            private int docID = -1;

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.docID = target;
                return NumericDoubleValues.this.advanceExact(target);
            }

            @Override
            public long longValue() throws IOException {
                return Double.doubleToRawLongBits(NumericDoubleValues.this.doubleValue());
            }

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int advance(int target) throws IOException {
                return NumericDoubleValues.this.advance(target);
            }
        };
    }

    public NumericDocValues getRawFloatValues() {
        return new AbstractNumericDocValues(){
            private int docID = -1;

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.docID = target;
                return NumericDoubleValues.this.advanceExact(target);
            }

            @Override
            public long longValue() throws IOException {
                return Float.floatToRawIntBits((float)NumericDoubleValues.this.doubleValue());
            }

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int advance(int target) throws IOException {
                return NumericDoubleValues.this.advance(target);
            }
        };
    }

    public int advance(int target) throws IOException {
        throw new UnsupportedOperationException();
    }
}

